% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{MASTDETest}
\alias{MASTDETest}
\title{Differential expression using MAST}
\usage{
MASTDETest(object, cells.1, cells.2, genes.use = NULL, latent.vars = NULL,
  assay.type = "RNA", ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to use for test}

\item{latent.vars}{Confounding variables to adjust for in DE test. Default is
"nUMI", which adjusts for cellular depth (i.e. cellular detection rate). For
non-UMI based data, set to nGene instead.}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}

\item{\dots}{Additional parameters to zero-inflated regression (zlm) function
in MAST}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identifies differentially expressed genes between two groups of cells using
a hurdle model tailored to scRNA-seq data. Utilizes the MAST package to run
the DE testing.
}
\details{
To use this method, please install MAST, using instructions at https://github.com/RGLab/MAST/
}
\examples{
\dontrun{
  pbmc_small
  MASTDETest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
              cells.2 = WhichCells(object = pbmc_small, ident = 2))
}

}
\references{
Andrew McDavid, Greg Finak and Masanao Yajima (2017). MAST: Model-based
Analysis of Single Cell Transcriptomics. R package version 1.2.1.
https://github.com/RGLab/MAST/
}
