% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{WilcoxDETest}
\alias{WilcoxDETest}
\title{Differential expression using Wilcoxon Rank Sum}
\usage{
WilcoxDETest(object, cells.1, cells.2, min.cells = 3, genes.use = NULL,
  print.bar = TRUE, assay.type = "RNA", ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{min.cells}{Minimum number of cells expressing the gene in at least one
of the two groups}

\item{genes.use}{Genes to use for test}

\item{print.bar}{Print a progress bar}

\item{assay.type}{Type of assay to perform DE for (default is RNA)}

\item{...}{Extra parameters passed to wilcox.test}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identifies differentially expressed genes between two groups of cells using
a Wilcoxon Rank Sum test
}
\examples{
pbmc_small
WilcoxDETest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
            cells.2 = WhichCells(object = pbmc_small, ident = 2))

}
