% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{KMeansHeatmap}
\alias{KMeansHeatmap}
\title{Plot k-means clusters}
\usage{
KMeansHeatmap(object, cells.use = object@cell.names, genes.cluster = NULL,
  max.genes = 1e+06, slim.col.label = TRUE, remove.key = TRUE,
  row.lines = TRUE, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{cells.use}{Cells to include in the heatmap}

\item{genes.cluster}{Clusters to include in heatmap}

\item{max.genes}{Maximum number of genes to include in the heatmap}

\item{slim.col.label}{Instead of displaying every cell name on the heatmap,
display only the identity class name once for each group}

\item{remove.key}{Removes teh color key from the plot}

\item{row.lines}{Color separations of clusters}

\item{...}{Extra parameters to DoHeatmap}
}
\description{
Plot k-means clusters
}
\examples{
pbmc_small <- DoKMeans(object = pbmc_small, k.genes = 3)
KMeansHeatmap(object = pbmc_small)

}
\seealso{
\code{DoHeatmap}
}
