% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{GetDimReduction}
\alias{GetDimReduction}
\title{Dimensional Reduction Accessor Function}
\usage{
GetDimReduction(object, reduction.type = "pca", slot = "gene.loadings")
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{Type of dimensional reduction to fetch (default is PCA)}

\item{slot}{Specific information to pull (must be one of the following:
"cell.embeddings", "gene.loadings", "gene.loadings.full", "sdev", "key", "misc")}
}
\value{
Returns specified slot results from given reduction technique
}
\description{
General accessor function for dimensional reduction objects. Pulls slot
contents for specified stored dimensional reduction analysis.
}
\examples{
pbmc_small
# Get the PCA cell embeddings and print the top left corner
GetDimReduction(object = pbmc_small, reduction.type = "pca",
                slot = "cell.embeddings")[1:5, 1:5]
# Get the standard deviation of each PC
GetDimReduction(object = pbmc_small, reduction.type = "pca", slot = "sdev")

}
