% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.analysis.R
\name{response.analysis}
\alias{response.analysis}
\title{Response Analysis}
\usage{
response.analysis(...)
}
\arguments{
\item{...}{Matrix or data frame.
Responses matrices for two different groups}
}
\value{
A list containing objects:

\item{total}{A vector with the total responses given by each participant. A \emph{t}-test
is used to compare, on average, whether one group provides more response
than the other}

\item{unique}{A vector with the number of unique responses provided by both groups
(\code{Total Across Groups}), the number of unique responses provided by
each group (\code{Total}), and the number of unique resposnes provided by each
group that were \emph{not} provided by the other group (\code{Unique}). A
McNemar's test is used to compare whether the number of unique responses
are different between groups}
}
\description{
Computes the difference in the total and unique
number of responses between two groups (follows Christensen et al., 2018)
}
\examples{
# Obtain data
low <- open.clean[which(open.group == "Low"),]
high <- open.clean[which(open.group == "High"),]

# Perform analysis
response.analysis(low, high)

}
\references{
Christensen, A. P., Kenett, Y. N., Cotter, K. N., Beaty, R. E., & Silvia, P. J. (2018).
Remotely close associations: Openness to experience and semantic memory structure.
\emph{European Journal of Personality}, \emph{32}, 480-492.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
