% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\title{Statistical description}
\usage{
describe(x, ...)
}
\arguments{
\item{x}{A data frame, matrix, vector, or formula.}

\item{\dots}{Additional arguments passed to \code{describe.default}.}
}
\description{
Provides description of a vector, matrix, data.frame.
}
\examples{
\dontrun{
 describe(turnout)
 desc <- describe(turnout)
 desc$v1   # print description for just v1
 desc[c('v2','v3')]    # print description for two variables.
 desc[sort(names(desc))] # print in alphabetic order by column names.

# Describing part of a data frame:
 with(turnout, describe(v1 ~ v2*v3 + v4) )
 with(turnout, describe(~ v2 + v3) )
 with(turnout, describe(~ v2 + v3, weights=freqs)) # weighted analysis
}
}

