% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ci.R
\docType{methods}
\encoding{UTF-8}
\name{ci}
\alias{ci}
\alias{ci,ANY-method}
\alias{ci,numeric,numeric,numeric,logical,ANY-method}
\title{Confidence Intervals}
\usage{
ci(x, conf.level = 0.95, alpha = 1 - conf.level, ...)

\S4method{ci}{ANY}(x, conf.level = 0.95, alpha = 1 - conf.level,
  na.rm = FALSE, ...)
}
\arguments{
\item{x}{a vector of data.}

\item{conf.level}{confidence level. Default is 0.95.}

\item{alpha}{confidence level. Default is 1-conf.level.}

\item{na.rm}{A logical value, default is \code{FALSE}}

\item{\dots}{Extra parameters.}
}
\value{
\item{CI lower}{Lower bound of interval.}
\item{Est. Mean}{Mean of data.}
\item{CI upper}{Upper bound of interval.}
\item{Std. Error}{Standard Error of the mean.}
}
\description{
Calculates the confidence intervals of a vector.
}
\examples{
set.seed(51)
x = rnorm(1000)
ci(x, conf.level=.95)
}
\keyword{Stats}
\keyword{Univariate}

