% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype_functions.R
\name{mergeGenotypeStringCoverage}
\alias{mergeGenotypeStringCoverage}
\title{Merge genotypeIdentifiedList and stringCoverageList.}
\usage{
mergeGenotypeStringCoverage(
  stringCoverageListObject,
  noiseGenotypeIdentifiedListObject
)
}
\arguments{
\item{stringCoverageListObject}{a stringCoverageList-object, created using the \link{stringCoverage}-function.}

\item{noiseGenotypeIdentifiedListObject}{a noiseGenotypeIdentifiedList-object, created using the \link{getGenotype}-function.}
}
\value{
Returns a list, with an element for every marker in extractedReadsList-object, each element contains the string coverage of all unique strings of a given marker.
}
\description{
\code{mergeGenotypeStringCoverage} merges genotypeIdentifiedList-objects and stringCoverageList-objects.
}
\examples{
# Strings aggregated by 'stringCoverage()'
data("stringCoverageList")
# Genotypes identified by 'getGenotype()'
data("genotypeList")
# Noise identified by 'identifyNoise()'
data("noiseList")

mergeGenotypeStringCoverage(stringCoverageList, genotypeList)
mergeNoiseStringCoverage(stringCoverageList, noiseList)
}
