% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\docType{methods}
\name{binKmeans2,msi.dataset-method}
\alias{binKmeans2,msi.dataset-method}
\alias{binKmeans2}
\title{Return a binary mask generated applying k-means clustering
on peaks intensities. A finer segmentation is obtained by using a larger
number of clusters than 2. The off-sample clusters are merged looking at the
most frequent labels in the image corners. The lookup areas are defined by
the kernel size.}
\usage{
\S4method{binKmeans2}{msi.dataset}(object, mzQuery = numeric(),
  useFullMZ = TRUE, mzTolerance = numeric(), numClusters = 4,
  kernelSize = c(3, 3, 3, 3), numCores = 1, verbose = TRUE)
}
\arguments{
\item{object}{\link{msi.dataset-class} object}

\item{mzQuery}{numeric. Values of m/z used to calculate the reference image.
2 values are interpreted as interval, multiple or single values are searched
in the m/z vector. It should be left unset when using \code{useFullMZRef = TRUE}.}

\item{useFullMZ}{logical (default = TRUE). Whether all the peaks should be
used to calculate the reference image.}

\item{mzTolerance}{numeric. Tolerance in PPM to match the \code{mzQueryRef}
values in the m/z vector. Only valid when \code{useFullMZ = FALSE}.}

\item{numClusters}{numeric (default = 4). Number of k-means clusters.}

\item{kernelSize}{4D array (default = c(3, 3, 3, 3)). Array of sizes in pixels of the corner
kernels used to identify the off-sample clusters. The elements represent the
size of the top-left, top-right, bottom-right and bottom-left corners. A negative
value can be used to skip the corresponding corner.}

\item{numCores}{(default = 1). Multi-core parallel computation of k-means clusters.}

\item{verbose}{logical (default = `TRUE``). Show additional output.}
}
\value{
\link{ms.image-class} object representing the binary mask image.
}
\description{
Return a binary mask generated applying k-means clustering
on peaks intensities. A finer segmentation is obtained by using a larger
number of clusters than 2. The off-sample clusters are merged looking at the
most frequent labels in the image corners. The lookup areas are defined by
the kernel size.
}
\author{
Paolo Inglese \email{p.inglese14@imperial.ac.uk}
}
