% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilitiesEvaluate.R
\name{ocheck}
\alias{ocheck}
\alias{ocheck3}
\alias{count_npairs}
\alias{count_nallpairs}
\title{functions to evaluate low order projection properties of (O)SOAs}
\usage{
ocheck(D, verbose = FALSE)

ocheck3(D, verbose = FALSE)

count_npairs(D, minn = 1)

count_nallpairs(ns)
}
\arguments{
\item{D}{a matrix with factor levels or an object of class \code{SOA};\cr
factor levels can start with 0 or with 1, and need to be consecutively numbered}

\item{verbose}{logical; if \code{TRUE}, additional information is printed
(table of correlations)}

\item{minn}{small integer number; the function counts pairs that are covered at least \code{minn} times}

\item{ns}{vector of numbers of levels for each column}
}
\value{
Functions \code{ocheck} and \code{ocheck3} return a logical.

Functions \code{count_npairs} returns a vector of
counts for level combinations covered in factor pairs (in the order of the columns of
\code{DoE.base:::nchoosek(ncol(D),2)}) for the array in \code{D},\cr
function \code{count_nallpairs} provides the total number of level combinations for
designs with numbers of levels given in \code{ns} (and thus can be used to obtain
a denominator for \code{count_npairs}).
}
\description{
\code{ocheck} and \code{ocheck3} evaluate pairwise or 3-orthogonality of columns,
\code{count_npairs} evaluates the number of level pairs in 2D projections,
\code{count_nallpairs} calculates corresponding total numbers of pairs.
}
\examples{
#' ## Shi and Tang strength 3+ construction in 7 8-level factors for 32 runs
D <- SOAs_8level(32, optimize=FALSE)
## is an OSOA
ocheck(D)

## an OSOA of strength 3 with 3-orthogonality
## 4 columns in 27 levels each
## second order model matrix

D_o <- OSOAs_LiuLiu(DoE.base::L81.3.10, optimize=FALSE)
ocheck3(D_o)

## benefit of 3-orthogonality for second order linear models
colnames(D_o) <- paste0("X", 1:4)
y <- stats::rnorm(81)
mylm <- stats::lm(y~(X1+X2+X3+X4)^2 + I(X1^2)+I(X2^2)+I(X3^2)+I(X4^2),
                   data=as.data.frame(scale(D_o, scale=FALSE)))
crossprod(stats::model.matrix(mylm))
}
\author{
Ulrike Groemping
}
