% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XiaoXuMDLE.R
\name{XiaoXuMDLE}
\alias{XiaoXuMDLE}
\alias{createF}
\alias{optimize}
\title{Implementation of the Xiao Xu TA algorithm
(experimental, for comparison with MDLEs only)}
\usage{
XiaoXuMDLE(
  oa,
  ell,
  noptim.oa = 1,
  nseq = 2000,
  nrounds = 50,
  nsteps = 3000,
  dmethod = "manhattan",
  p = 50
)

createF(Dc, Dp, s, ell, nseq = 2000)

optimize(
  Dc,
  s,
  ell,
  Fhat,
  nrounds = 50,
  nsteps = 3000,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{oa}{matrix or data.frame that contains an ingoing symmetric OA. Levels must be denoted as 0 to s-1 or as 1 to s.}

\item{ell}{the multiplier for each number of levels}

\item{noptim.oa}{integer: number of optimization rounds applied to initial oa itself before starting expansion}

\item{nseq}{tuning parameters for TA algorithm}

\item{nrounds}{tuning parameters for TA algorithm}

\item{nsteps}{tuning parameters for TA algorithm}

\item{dmethod}{distance method for \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}

\item{Dc}{matrix}

\item{Dp}{matrix}

\item{s}{original number of levels}

\item{Fhat}{distribution function (created with \code{createF})}
}
\value{
\code{XiaoXuMDLE} returns a matrix with attribute \code{phi_p}.

\code{createF} returns a distribution function.

\code{optimize} returns a matrix with attribute \code{phi_p}.
}
\description{
Implementation of the Xiao Xu TA algorithm
(experimental, for comparison with MDLEs only)
}
\details{
The ingoing \code{oa} is optimized by function \code{\link{phi_optimize}},
using \code{noptim.rounds=noptim.oa}; this yields the matrix \code{Dp} for use
in the internal functions \code{\link{DcFromDp}} and \code{createF}.\cr
Function \code{XiaoXuMDLE} returns the value
that is produced by applying the internal function \code{optimize}
to the resulting \code{Dc} and \code{F}.
}
\examples{
## create 8-level columns from 4-level columns
XiaoXuMDLE(DoE.base::L16.4.5, 2, nrounds = 5, nsteps=50)

}
\references{
For full detail, see \code{\link{SOAs-package}}.

Xiao and Xu (2018)
}
\keyword{internal}
