% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{ancestry}
\alias{ancestry}
\alias{ancestors}
\alias{descendants}
\alias{parents}
\alias{siblings}
\title{Node ancestry utilities}
\usage{
ancestors(g, nodes)

descendants(g, nodes)

parents(g, nodes)

siblings(g, nodes)
}
\arguments{
\item{g}{An igraph object.}

\item{nodes}{the nodes in the graph of which to get the ancestry.}
}
\value{
a sorted vector of nodes.
}
\description{
Get ancestry for a collection of nodes in a graph.
These functions are wrappers for the original \code{SEMID} R package.
}
\examples{

# Get all ancestors
an <- V(sachs$graph)[ancestors(sachs$graph, "Erk")]; an

# Get parents
pa <- V(sachs$graph)[parents(sachs$graph, "PKC")]; pa

# Get descendants
de <- V(sachs$graph)[descendants(sachs$graph, "PKA")]; de

# Get siblings
sib <- V(sachs$graph)[siblings(sachs$graph, "PIP3")]; sib

}
\references{
Rina Foygel Barber, Mathias Drton and Luca Weihs (2019). SEMID:
Identifiability of Linear Structural Equation Models. R package
version 0.3.2. <https://CRAN.R-project.org/package=SEMID/>
}
