% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinRtData.R
\name{joinRtData}
\alias{joinRtData}
\title{Join RtData}
\usage{
joinRtData(rtData, rtData2)
}
\arguments{
\item{rtData}{A nested list as required by \code{summaryWidget}}

\item{rtData2}{A nested list as required by \code{summaryWidget}}
}
\value{
A nested list as required by \code{summaryWidget}
}
\description{
Joins two nested lists in the format required by \code{summaryWidget}. This may
be useful for merging estimates from disparate data sources or linking national level estimates
with subnational estimates
}
\examples{

\donttest{
base_url <- "https://raw.githubusercontent.com/epiforecasts/covid-rt-estimates/master/"
subnational <-   national <- list("Cases" = readInEpiNow2(
path = paste0(base_url, "subnational/italy/cases/summary"),
region_var = "region"))


national <- list("Cases" = readInEpiNow2(
path = paste0(base_url, "national/cases/summary"),
region_var = "country"),
regions = "Italy")

out <- list()
out$Cases <- joinRtData(subnational$Cases, national$Cases)
}
}
