% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeData.R
\name{writeData}
\alias{writeData}
\title{Write Simulx Dataset}
\usage{
writeData(
  project = NULL,
  filename = "simulated_dataset.csv",
  sep = ",",
  ext = "csv",
  nbdigits = 5
)
}
\arguments{
\item{project}{(\emph{string}) a simulx project.
If no project specified, the function will run on the project that is already loaded.}

\item{filename}{(\emph{string}) (\emph{optional}) file path to dataset.
(default "simulated_dataset.csv")
In case of multiple replicates, the function creates one dataset per replicate with name $filename_repi
If filename contains an extension, it must be "csv" or "txt". If it does not, extension is defined by \code{ext} argument.}

\item{sep}{(\emph{string}) (\emph{optional}) Separator used to write dataset file. (default ",")
It must be one of {"\\t", " ", ";", ","}}

\item{ext}{(\emph{bool}) (\emph{optional}) Extension used to write dataset file. (default "csv")
It must be one of {"csv", "txt"}
To defined only if filename with no extension}

\item{nbdigits}{(\emph{integer}) (\emph{optional}) number of decimal digits in output file.
(default = 5)}
}
\value{
a dataframe if one single simulation, a list of dataframe if multiple replicates.
}
\description{
Format outputs of simulx simulations and write datasets in monolix
and pkanalix project format.
}
\details{
WARNING: \code{writeData} function is not implemented for simulx project with regressors in MonolixSuite version 2020R1
}
\examples{
\dontrun{
  # rssimulxDemo.smlx is a Simulx project. This demo simulates three groups
  # with different dose levels: low, medium and high.
  # Groups have the same number of individuals, population parameters,
  # distribution of covariates and outputs.
  
  # In this example we write data in the home directory with the name demo_simulx
  # and a txt extension
  writeData("rssimulxDemo.smlx", filename = "demo_simulx", ext = "txt")
  
} 
}
