% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FeatureSelection.R
\name{FS.all.reducts.computation}
\alias{FS.all.reducts.computation}
\title{A function for computing all decision reducts of a decision system}
\usage{
FS.all.reducts.computation(discernibilityMatrix)
}
\arguments{
\item{discernibilityMatrix}{an \code{"DiscernibilityMatrix"} object representing
a discernibility matrix of a decision system.}
}
\value{
An object of a class \code{"ReductSet"}.
}
\description{
A wrapper function used for generating all decision reducts of a decision system. The reducts
are obtained from a discernibility matrix which can be computed using methods based on RST
and FRST. Therefore, it should be noted that before calling the function, we need to
compute a discernibility matrix using \code{\link{BC.discernibility.mat.RST}} or
\code{\link{BC.discernibility.mat.FRST}}.
}
\examples{
########################################################
## Example 1: Generate all reducts and
##            a new decision table using RST
########################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relation discernibility matrix
res.2 <- BC.discernibility.mat.RST(decision.table, range.object = NULL)

## generate all reducts
reduct <- FS.all.reducts.computation(res.2)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))

##############################################################
## Example 2: Generate all reducts and
##            a new decision table using FRST
##############################################################
\dontrun{data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relation discernibility matrix
control.1 <- list(type.relation = c("crisp"),
                type.aggregation = c("crisp"),
                t.implicator = "lukasiewicz", type.LU = "implicator.tnorm")
res.1 <- BC.discernibility.mat.FRST(decision.table, type.discernibility = "standard.red",
                                    control = control.1)

## generate single reduct
reduct <- FS.all.reducts.computation(res.1)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))}
}
\author{
Andrzej Janusz
}
\seealso{
\code{\link{BC.discernibility.mat.RST}}, \code{\link{BC.discernibility.mat.FRST}}.
}

