\name{D.local.discernibility.matrix.RST}
\alias{D.local.discernibility.matrix.RST}
\title{The local strategy algorithm}
\usage{
  D.local.discernibility.matrix.RST(decision.table, ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{...}{other parameters,}
}
\value{
  A class \code{"Discretization"} that contains the
  following components: \itemize{ \item \code{cut.values}:
  a list representing cut values of each considered
  attributes. \item \code{type.method}: a type of method
  which is used to define cut values.

  In this case, it is \code{"local.strategy"}. \item
  \code{type.task}: a type of task which is
  \code{"discretization"}. \item \code{model}: a type of
  model which is \code{"RST"}. }
}
\description{
  This is a function that implements the local strategy
  algorithm based on rough set theory proposed by (Jan G.
  Bazan et al, 2000), for discretization tasks.
}
\details{
  The local strategy is an algorithm which implements a
  decision tree to calculate the quality of a cut (i.e.
  number of objects discerned by cut). In other words, it
  finds the best cut by dividing the object set into two
  subsets of objects, then calculating and repeating the
  processes until some stopping condition holds. The
  quality is measured by the number of pairs of objects
  from X discerned by cut values. The following is the
  equation used to calculate the number of pairs of objects
  \eqn{W}. For any cut \eqn{(a, c) \in C_{A}}, and \eqn{X
  \subseteq U}:

  \eqn{W^X(a,c) = l^X(a,c) \cdot r^X(a,c) -
  \displaystyle\sum\limits_{i=1}^r {l_{i}^X(a,c) \cdot
  r_{i}^X(a,c)}}

  where \eqn{l^X} and \eqn{r^X} are the number of objects
  on either side of \eqn{(a,c)} and \eqn{l_{i}^X} and
  \eqn{r_{i}^X} are numbers of objects form \eqn{X}
  belonging to the \eqn{j^{th}} decision class and being on
  the left-hand-side and right-hand-side of the cut
  \eqn{(a,c)}, respectively.

  This function will detect and perform converting the
  continuous attributes into nominal ones according to
  states \code{FALSE} in parameter
  \code{nominal.attributes}. And, it should be noted that
  the output of this function is a class containing cut
  values. In order to generate new decision table,
  \code{\link{SF.applyDecTable}} is executed.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
dt.ex1 <- data.frame(c(1, 2, 3, 3, 4, 5, 6, 7, 7, 8), c(2,5, 7, 6, 6, 6, 1, 8, 1, 1),
                             c(3, 5, 1, 1, 3, 6, 8, 8, 1, 1), c(0, 1, 2, 1, 0, 1, 2, 2, 0, 0))
colnames(dt.ex1) <- c("a1", "a2", "a3", "d")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4, indx.nominal = c(4))

cut.values <- D.local.discernibility.matrix.RST(decision.table)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, cut.values)
}
\references{
  Jan G. Bazan, Hung Son Nguyen, Sinh Hoa Nguyen, Piotr
  Synak, and Jakub Wroblewski, "Rough Set Algorithms in
  Classification Problem", Chapter 2 In: L. Polkowski, S.
  Tsumoto and T.Y. Lin (eds.): Rough Set Methods and
  Applications Physica-Verlag, Heidelberg, New York, p. 49
  - 88 ( 2000).
}
\seealso{
  \code{\link{D.max.discernibility.matrix.RST}},
  \code{\link{D.discretize.quantiles.RST}},

  \code{\link{D.discretize.equal.intervals.RST}}, and
  \code{\link{D.global.discernibility.heuristic.RST}}
}

