% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors_calibration.R
\name{calibrate_meta_analytic}
\alias{calibrate_meta_analytic}
\title{Create meta-analytic predictive prior distributions}
\usage{
calibrate_meta_analytic(
  datasets,
  distributions = c("exp-aft", "weibull-aft", "lnorm-aft", "llogis-aft", "gamma-aft"),
  prior_mu = prior("cauchy", parameters = list(location = 0, scale = 100)),
  prior_tau = prior("cauchy", parameters = list(location = 0, scale = 10), truncation =
    list(0, Inf)),
  ...
)
}
\arguments{
\item{datasets}{list of data.frames containing the historical
data. Each data.frame must contain a column named \code{"time"}
with the survival times and a column named \code{"status"}
with the censoring status.}

\item{distributions}{vector of parametric families for which
prior distributions ought to be calibrated}

\item{prior_mu}{prior distribution for the the meta-analytic mean parameter}

\item{prior_tau}{prior distribution for the the meta-analytic heterogeneity parameter}

\item{...}{additional parameters to be passed to the meta-analytic function.
See \link[BayesTools:JAGS_fit]{BayesTools::JAGS_fit} for more details.}
}
\value{
returns a list of prior distribution for the intercepts
and auxiliary parameters.
}
\description{
Calibrates prior distributions for parametric
survival analysis based on historical data.
Returns a list of prior distribution for the intercepts
and auxiliary parameters.
}
