% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN.R
\name{ResIN}
\alias{ResIN}
\title{ResIN}
\usage{
ResIN(
  df,
  node_vars = NULL,
  cor_method = "auto",
  weights = NULL,
  method_wCorr = "Polychoric",
  poly_ncor = 2,
  remove_negative = TRUE,
  EBICglasso = FALSE,
  EBICglasso_arglist = NULL,
  node_covars = NULL,
  node_costats = NULL,
  network_stats = FALSE,
  cluster = TRUE,
  seed = 42
)
}
\arguments{
\item{df}{A data-frame object containing the raw data.}

\item{node_vars}{An optional character string detailing the attitude item columns to be selected for ResIN analysis (i.e. the subset of attitude variables in df).}

\item{cor_method}{Which correlation method should be used? Defaults to "auto" which applies the \code{cor_auto} function from the \code{qgraph} package. Possible arguments are \code{"auto"}, \code{"pearson"}, \code{"kendall"}, and \code{"spearman"}.}

\item{weights}{An optional continuous vector of survey weights. Should have the same length as number of observations in df. If weights are provided, weighted correlation matrix will be estimated with the \code{weightedCorr} function from the \code{wCorr} package.}

\item{method_wCorr}{If weights are supplied, which method for weighted correlations should be used? Defaults to \code{"Polychoric"}. See \code{wCorr::weightedCorr} for all correlation options.}

\item{poly_ncor}{How many CPU cores should be used to estimate polychoric correlation matrix? Only used if \code{cor_method = "polychoric"}.}

\item{remove_negative}{Should all negative correlations be removed? Defaults to TRUE (highly recommended). Setting to FALSE makes it impossible to estimate a force-directed network layout. Function will use igraph::layout_nicely instead.}

\item{EBICglasso}{Should a sparse, Gaussian-LASSO ResIN network be estimated? Defaults to FALSE. If set to TRUE, \code{EBICglasso} function from the \code{qgraph} packages performs regularization on (nearest positive-semi-definite) ResIN correlation matrix.}

\item{EBICglasso_arglist}{An argument list feeding additional instructions to the \code{EBICglasso} function if \code{EBICglasso} is set to TRUE.}

\item{node_covars}{An optional character string selecting quantitative covariates that can be used to enhance ResIN analysis. Typically, these covariates provide grouped summary statistics for item response nodes. (E.g.: What is the average age or income level of respondents who selected a particular item response?) Variable names specified here should match existing columns in \code{df}.}

\item{node_costats}{If any \code{node_covars} are selected, what summary statistics should be estimated from them? Argument should be a character vector of the same length of \code{node_covars}and call a base-R function. (E.g. \code{"mean"}, \code{"median"}, \code{"sd"}). The first element in \code{node_costats} specifies the summary statistic extracted from the first element in \code{node_covars}, and so on.}

\item{network_stats}{Should common network structuration and centralization metrics be extracted? Calls \code{qgraph::centrality_auto} and \code{DirectedClustering::ClustF} to the ResIN graph object to extract network average betweenness, closeness, strength centrality (mean) and centralization scores (sd). Also estimates network expected influence, average path length, and global clustering coefficients.}

\item{cluster}{Optional, should community detection be performed on item response network? Defaults to FALSE. If set to TRUE, performs "cluster_leading_eigen" function from the igraph package and stores results in plotting_frame.}

\item{seed}{Random seed for force-directed algorithm.}
}
\value{
A list object containing the ResIN adjacency matrix (\code{adj_matrix}), a numeric vector detailing which item responses belong to which item (\code{same_items}), a ggplot-ready edge-list type dataframe (\code{ggplot_frame}), a node-level dataframe (\code{plotting_frame}), a vector with the optional graph structuration (\code{graph_structuration}) and centralization (\code{graph_centralization}) statistics, as well as the dummy-coded item-response dataframe (\code{df_dummies}).
}
\description{
Performs Response Item-Network analysis (ResIN)
}
\examples{

## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)
library(ggplot2)

# Apply the ResIN function to toy Likert data:
output <- ResIN(lik_data, cor_method = "spearman", network_stats = TRUE)

# Create a basic outcome plot with ggplot
output$ggplot_frame <- output$ggplot_frame[order(output$ggplot_frame$Strength,
                                                 decreasing = FALSE), ]
ResIN_plot <- ggplot2::ggplot(output$ggplot_frame)+
  geom_curve(data = output$ggplot_frame, aes(x = from.x, xend = to.x, y = from.y,
                                             yend = to.y, linewidth = weight,
                                             color = Strength), curvature = 0.2)+
  geom_point(aes(x = from.x, y = from.y, shape = as.factor(cluster)), size = 8)+
  geom_point(aes(x = to.x, y = to.y), size = 8)+
  geom_text(data = output$ggplot_frame, aes(x = from.x, y = from.y, label = from),
            size = 3, color = "white")+
  geom_text(data = output$ggplot_frame, aes(x = to.x, y = to.y, label = to),
            size = 3, color = "white")+
  ggtitle("ResIN example  plot")+
  theme_dark()+
  theme(axis.text.x = element_blank(), axis.title.x = element_blank(),
        axis.text.y = element_blank(), axis.title.y = element_blank(),
        axis.ticks = element_blank(), panel.grid.major = element_blank(),
        panel.grid.minor = element_blank(), legend.position = "none",
        legend.text = element_blank(), plot.title = element_text(hjust = 0.5))

ResIN_plot

}
