/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.text;

import java.io.IOException;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTHyperlink;
import org.docx4j.dml.CTRegularTextRun;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.dml.CTTextParagraph;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTFtnEdnRef;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.pptx4r.elements.Utils;
import org.lysis.reporters.text.ExternalLink;
import org.lysis.reporters.text.FootNote;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class Paragraph
extends DocComponent
implements HTML4R {
    private LinkedHashMap<Integer, String> hyperlink;
    private LinkedHashMap<Integer, String> textList = new LinkedHashMap();
    private LinkedHashMap<Integer, TextProperties> formatList = new LinkedHashMap();
    private LinkedHashMap<Integer, FootNote> footnoteList;
    private int index = 0;
    private boolean hasBookmark;
    private JAXBElement<CTBookmark> bmStart;
    private JAXBElement<CTMarkupRange> bmEnd;
    private boolean vanilla_format = false;

    public Paragraph() {
        this.hyperlink = new LinkedHashMap();
        this.footnoteList = new LinkedHashMap();
    }

    public void setVanilla() {
        this.vanilla_format = true;
    }

    public void setBookmark(String bookmark, BigInteger bookmarkID) {
        this.hasBookmark = true;
        ObjectFactory factory = Context.getWmlObjectFactory();
        CTBookmark bm = new CTBookmark();
        bm.setId(bookmarkID);
        bm.setName(bookmark);
        this.bmStart = factory.createBodyBookmarkStart(bm);
        CTMarkupRange mr = factory.createCTMarkupRange();
        mr.setId(bookmarkID);
        this.bmEnd = factory.createBodyBookmarkEnd(mr);
    }

    public void addFootnoteToLastEntry(FootNote fn) {
        this.footnoteList.put(this.index, fn);
    }

    public String asText() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                out = String.valueOf(out) + this.textList.get(i);
                ++i;
            }
        }
        return out;
    }

    public void addText(String value, TextProperties tp) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, tp);
        this.hyperlink.put(this.index, "");
        this.footnoteList.put(this.index, null);
    }

    public void addText(String value) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, null);
        this.hyperlink.put(this.index, "");
        this.footnoteList.put(this.index, null);
    }

    public void addText(String value, TextProperties tp, String hlink) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, tp);
        this.hyperlink.put(this.index, hlink);
        this.footnoteList.put(this.index, null);
    }

    public void addText(String value, String hlink) throws IOException {
        ++this.index;
        this.textList.put(this.index, value);
        this.formatList.put(this.index, null);
        this.hyperlink.put(this.index, hlink);
        this.footnoteList.put(this.index, null);
    }

    public void addParagraph(Paragraph value) throws IOException {
        value = Paragraph.reindex(value, this.index);
        this.textList.putAll(value.textList);
        this.formatList.putAll(value.formatList);
        this.hyperlink.putAll(value.hyperlink);
        this.footnoteList.putAll(value.footnoteList);
        this.index += value.index;
    }

    private static Paragraph reindex(Paragraph value, int add) {
        if (value.index < 1) {
            return value;
        }
        LinkedHashMap<Integer, String> newTextList = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, TextProperties> newFormatList = new LinkedHashMap<Integer, TextProperties>();
        LinkedHashMap<Integer, String> newHyperLinkList = new LinkedHashMap<Integer, String>();
        LinkedHashMap<Integer, FootNote> newFootnoteList = new LinkedHashMap<Integer, FootNote>();
        int i = 1;
        while (i <= value.index) {
            newTextList.put(i + add, value.textList.get(i));
            newFormatList.put(i + add, value.formatList.get(i));
            newHyperLinkList.put(i + add, value.hyperlink.get(i));
            newFootnoteList.put(i + add, value.footnoteList.get(i));
            ++i;
        }
        value.textList = newTextList;
        value.formatList = newFormatList;
        value.hyperlink = newHyperLinkList;
        value.footnoteList = newFootnoteList;
        return value;
    }

    public void setTextProperties(TextProperties tp) {
        for (int key : this.formatList.keySet()) {
            this.formatList.put(key, tp);
        }
    }

    public String toString() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                out = String.valueOf(out) + this.textList.get(i);
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                String span = "";
                String[] texts = this.textList.get(i).split("\n");
                int cid = 0;
                while (cid < texts.length) {
                    if (cid > 0) {
                        span = String.valueOf(span) + "<br>";
                    }
                    span = String.valueOf(span) + texts[cid];
                    if (this.formatList.get(i) != null) {
                        TextProperties tp = this.formatList.get(i);
                        String css = this.vanilla_format ? Format.getJSString(tp.get_html_pr_vanilla()) : Format.getJSString(tp.get_html_pr());
                        span = utils.span_style(span, css);
                    } else {
                        span = utils.span(span);
                    }
                    ++cid;
                }
                if (!this.hyperlink.get(i).equals("")) {
                    span = utils.a(span, this.hyperlink.get(i));
                }
                if (this.footnoteList.get(i) != null && this.counters != null) {
                    this.footnoteList.get(i).setHTMLReference(this.list_id, this.counters, this.numbDefinition);
                    span = String.valueOf(span) + utils.tooltip("", this.footnoteList.get(i).getHTML());
                }
                out = String.valueOf(out) + span;
                ++i;
            }
        }
        return out;
    }

    private void fill_docx_par(P p) {
        if (this.index > 0) {
            int i = 1;
            while (i <= this.index) {
                String[] texts = this.textList.get(i).split("\n");
                int cid = 0;
                while (cid < texts.length) {
                    R run = new R();
                    if (cid > 0) {
                        Br br = new Br();
                        run.getContent().add(br);
                    }
                    if (this.formatList.get(i) != null) {
                        TextProperties tp = this.formatList.get(i);
                        Text text = new Text();
                        text.setValue(texts[cid]);
                        text.setSpace("preserve");
                        run.getContent().add(text);
                        RPr rpr = tp.get_docx_pr();
                        run.setRPr(rpr);
                    } else {
                        Text text = new Text();
                        text.setValue(texts[cid]);
                        text.setSpace("preserve");
                        run.getContent().add(text);
                    }
                    if (!this.hyperlink.get(i).equals("")) {
                        ExternalLink extL = new ExternalLink(this.hyperlink.get(i));
                        extL.setWordMLPackage(this.getDOCXMLPackage());
                        P.Hyperlink hp = null;
                        try {
                            hp = (P.Hyperlink)extL.get_docx_elt();
                            hp.getContent().add(run);
                            p.getContent().add(hp);
                        }
                        catch (Exception e) {
                            p.getContent().add(run);
                        }
                    } else {
                        p.getContent().add(run);
                    }
                    ++cid;
                }
                if (this.hasBookmark) {
                    p.getContent().add(0, this.bmStart);
                    p.getContent().add(1, this.bmEnd);
                }
                if (this.footnoteList.get(i) != null) {
                    try {
                        this.footnoteList.get(i).setNumberingDefinitionsPart(this.ndp);
                        this.footnoteList.get(i).setOrderedNumID(this.ordered_num_id);
                        this.footnoteList.get(i).setUnorderedNumID(this.unordered_num_id);
                        this.footnoteList.get(i).setDOCXMLPackage(this.getDOCXMLPackage());
                        this.footnoteList.get(i).get_docx_elt();
                        CTFtnEdnRef ff = new CTFtnEdnRef();
                        ff.setId(BigInteger.valueOf(this.footnoteList.get(i).getFootnoteID()));
                        ObjectFactory of = new ObjectFactory();
                        R runreference = new R();
                        runreference.getContent().add(of.createRFootnoteReference(ff));
                        runreference.setRPr(this.footnoteList.get(i).getTextProperties().get_docx_pr());
                        p.getContent().add(runreference);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    public P getDocxParagraph(String style) {
        P p = this.docx_mlp.getMainDocumentPart().createStyledParagraphOfText(style, "");
        this.fill_docx_par(p);
        return p;
    }

    public P getDocxParagraph() {
        P p = new P();
        this.fill_docx_par(p);
        return p;
    }

    public CTTextParagraph getPptxTextParagraph(SlidePart slidePart) throws Exception {
        CTTextParagraph textPar = new CTTextParagraph();
        if (this.index > 0) {
            List runs = textPar.getEGTextRun();
            int i = 1;
            while (i <= this.index) {
                CTRegularTextRun textRun = Utils.getRun(this.textList.get(i));
                runs.add(textRun);
                if (this.formatList.get(i) != null) {
                    TextProperties tp = this.formatList.get(i);
                    CTTextCharacterProperties rpr = tp.get_pptx_pr();
                    textRun.setRPr(rpr);
                } else {
                    CTTextCharacterProperties rpr = new CTTextCharacterProperties();
                    textRun.setRPr(rpr);
                }
                if (!this.hyperlink.get(i).equals("")) {
                    ExternalLink extL = new ExternalLink(this.hyperlink.get(i));
                    extL.setSlidePart(slidePart);
                    CTHyperlink hyperlink = (CTHyperlink)extL.get_pptx_elt();
                    textRun.getRPr().setHlinkClick(hyperlink);
                }
                ++i;
            }
        }
        return textPar;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

