/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docx4r.elements;

import java.math.BigInteger;
import java.util.List;
import org.docx4j.XmlUtils;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTColumns;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tbl;

public class SectionFactory {
    private BigInteger pageWidth = null;
    private BigInteger pageHeight = null;
    private int cols = 1;
    private int between_width = 0;
    private boolean do_column_break = false;
    private boolean page_break = false;
    private boolean is_open = false;
    private SectPr sectPr;

    public void setPageBreak(boolean b) {
        this.page_break = b;
    }

    public boolean getPageBreak() {
        return this.page_break;
    }

    public void open() {
        this.is_open = true;
    }

    public void close() {
        this.is_open = false;
    }

    public boolean isOpen() {
        return this.is_open;
    }

    public int getCols() {
        return this.cols;
    }

    public void setColumns(int c, int w) {
        this.cols = c;
        this.between_width = w;
    }

    public void setColumnBreak(boolean cb) {
        this.do_column_break = cb;
    }

    public void updateDocument(WordprocessingMLPackage basedoc) {
        if (this.do_column_break) {
            int sz = basedoc.getMainDocumentPart().getContent().size();
            Object last_obj = basedoc.getMainDocumentPart().getContent().get(sz - 1);
            Br br = new Br();
            br.setType(STBrType.COLUMN);
            if (last_obj.getClass().equals(Tbl.class)) {
                last_obj = basedoc.getMainDocumentPart().getContent().get(sz - 2);
                if (last_obj.getClass().equals(P.class)) {
                    ((P)last_obj).getContent().add(br);
                } else {
                    System.err.println("cannot add a column break because previous object is also a table.");
                }
            } else if (last_obj.getClass().equals(P.class)) {
                ((P)last_obj).getContent().add(0, br);
            }
            this.do_column_break = false;
        }
    }

    public static P getBreakColumn() {
        P p = new P();
        R r = new R();
        R.LastRenderedPageBreak pp = new R.LastRenderedPageBreak();
        r.getContent().add(pp);
        p.getContent().add(r);
        return p;
    }

    public void setPageDimensions(List<SectionWrapper> sections) {
        this.sectPr = (SectPr)XmlUtils.deepCopy((Object)sections.get(sections.size() - 1).getSectPr());
        this.pageWidth = this.sectPr.getPgSz().getW();
        this.pageHeight = this.sectPr.getPgSz().getH();
    }

    public SectPr getNewSectPr(boolean landscape) {
        SectPr newSectPr = (SectPr)XmlUtils.deepCopy((Object)this.sectPr);
        if (landscape) {
            newSectPr.getPgSz().setOrient(STPageOrientation.LANDSCAPE);
            if (this.pageWidth.intValue() > this.pageHeight.intValue()) {
                newSectPr.getPgSz().setH(this.pageHeight);
                newSectPr.getPgSz().setW(this.pageWidth);
            } else {
                newSectPr.getPgSz().setH(this.pageWidth);
                newSectPr.getPgSz().setW(this.pageHeight);
            }
        } else {
            newSectPr.getPgSz().setOrient(STPageOrientation.PORTRAIT);
            if (this.pageWidth.intValue() > this.pageHeight.intValue()) {
                newSectPr.getPgSz().setH(this.pageWidth);
                newSectPr.getPgSz().setW(this.pageHeight);
            } else {
                newSectPr.getPgSz().setH(this.pageHeight);
                newSectPr.getPgSz().setW(this.pageWidth);
            }
        }
        CTColumns ctcols = new CTColumns();
        ctcols.setNum(BigInteger.valueOf(this.cols));
        ctcols.setSpace(BigInteger.valueOf(this.between_width));
        newSectPr.setCols(ctcols);
        if (!this.page_break) {
            SectPr.Type type = new SectPr.Type();
            type.setVal("continuous");
            newSectPr.setType(type);
        }
        return newSectPr;
    }

    public SectPr getOriginalSectPr() {
        SectPr newSectPr = (SectPr)XmlUtils.deepCopy((Object)this.sectPr);
        return newSectPr;
    }
}

