\name{c_Rd}
\alias{c_Rd}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Concatenate Rd objects or pieces}
\description{Concatenates Rd objects or pieces}
\usage{
c_Rd(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{\dots}{objects to be concatenated, Rd objects or character
    strings, see `Details'.
  }
}
\details{
  The arguments may be a mixture of lists and character strings. The
  lists are typically "Rd" objects or pieces. The character strings may
  also be elements of "Rd" objects carrying "Rd_tag" attributes. The
  "Rd_tag" attribute of character strings for which it is missing is set
  to "TEXT". Finally, each character element of \code{\dots} is
  enclosed in \code{list}.

  Eventually all arguments become lists and they are concatenated using
  \code{c()}. If any of the arguments is of class "Rd", the class of the
  result is set to "Rd". Otherwise, the "Rd_tag" of the result is set to
  the first (if any) non-null "Rd_tag" in the arguments.

}
\value{
  An Rd object or a list whose attribute "Rd_tag" is set as descibed in `Details'
}

\author{Georgi N. Boshnakov}


%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{
a1 <- char2Rdpiece("Dummyname", "name")
a2 <- char2Rdpiece("Dummyallias1", "alias")
a3 <- char2Rdpiece("Dummy title", "title")
a4 <- char2Rdpiece("Dummy description", "description")

# The following are equivalent
# TODO: replace Rdo_empty() below with a function from Rdpack
#       and uncomment
# b1 <- c_Rd(Rdo_empty(), list(a1), list(a2), list(a3), list(a4))
# c1 <- c_Rd(Rdo_empty(), list(a1, a2, a3, a4))
# d1 <- c_Rd(Rdo_empty(), list(a1, a2), list(a3, a4))
# identical(c1,b1)
# identical(c1,d1)
# Rdo_show(b1)

# insert a newline
# TODO: replace Rdo_empty() below with a function from Rdpack
#       and uncomment
# d1n <- c_Rd(Rdo_empty(), list(a1,a2), Rdo_newline(), list(a3,a4))
# str(d1n)

# When most of the arguments are character strings
# the function 'list_Rd' may be more convenient.
u1 <- list_Rd(name = "Dummyname", alias = "Dummyallias1",
              title = "Dummy title", description = "Dummy description",
              Rd_class=TRUE )
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{RdoBuild}
%\keyword{RdoProgramming}
