% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NRSR.R
\name{do.nrsr}
\alias{do.nrsr}
\title{Non-convex Regularized Self-Representation}
\usage{
do.nrsr(
  X,
  ndim = 2,
  expl = 0.5,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  lbd = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{expl}{an exponent in \eqn{\ell_{2,l}} norm for sparsity. Must be in \eqn{(0,1)}, or \eqn{l=1} reduces to RSR problem.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{lbd}{nonnegative number to control the degree of self-representation by imposing row-sparsity.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
In the standard, convex RSR problem (\code{\link{do.rsr}}), row-sparsity for self-representation is
acquired using matrix \eqn{\ell_{2,1}} norm, i.e, \eqn{\|W\|_{2,1} = \sum \|W_{i:}\|_2}. Its non-convex
extension aims at achieving higher-level of sparsity using arbitrarily chosen \eqn{\|W\|_{2,l}} norm for
\eqn{l\in (0,1)} and this exploits Iteratively Reweighted Least Squares (IRLS) algorithm for computation.
}
\examples{
\donttest{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.integer(iris$Species)

#### try different exponents for regularization
out1 = do.nrsr(X, expl=0.01)
out2 = do.nrsr(X, expl=0.1)
out3 = do.nrsr(X, expl=0.5)

#### visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="NRSR::expl=0.01")
plot(out2$Y, main="NRSR::expl=0.1")
plot(out3$Y, main="NRSR::expl=0.5")
par(opar)
}

}
\references{
\insertRef{zhu_nonconvex_2017}{Rdimtools}
}
\seealso{
\code{\link{do.rsr}}
}
\author{
Kisung You
}
\concept{linear_methods}
