% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bds.R
\name{bds}
\alias{bds}
\title{Run 'Bloomberg Data Set' Queries}
\usage{
bds(securities, fields, options = NULL, overrides = NULL, identity = NULL,
  con = defaultConnection())
}
\arguments{
\item{securities}{A character vector with security symbols in
Bloomberg notation.}

\item{fields}{A character string with a single Bloomberg query field.}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{overrides}{An optional named character vector with override
values. Each field must have both a name (designating the override
being set) as well as a value.}

\item{identity}{An optional identity object.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A list with as a entries as there are entries in
\code{securities}; each list contains a data.frame with one row
per observations and as many columns as entries in
\code{fields}. If the list is of length one, it is collapsed into
a single data frame.
}
\description{
This function uses the Bloomberg API to retrieve 'bds' (Bloomberg
Data Set) queries
}
\examples{
\dontrun{
  bds("GOOG US Equity", "TOP_20_HOLDERS_PUBLIC_FILINGS")
}
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}

