% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvc_res.R
\name{rvn_rvc_res}
\alias{rvn_rvc_res}
\title{Create initial conditions file for Reservoirs}
\usage{
rvn_rvc_res(ff, initial_percent = 0, output = "initial_res_conditions.rvc")
}
\arguments{
\item{ff}{full file path to the reservoir information file}

\item{initial_percent}{an optional double for percentage of maximum stage to
use as initial condition; default 0.0}

\item{output}{file rvc lines are written to (default: initial_res_conditions.rvc)}
}
\value{
\item{TRUE}{return \code{TRUE} if the function is executed properly}
}
\description{
Write an initial conditions (rvc) format file for Raven,
with the calculated reservoir stages written in.
}
\details{
Writes an initial conditions format file for Raven
with the relevant initial reservoir stages. This file can be used directly
as the model rvc file, or one may copy and paste the information into a
separate rvc file for use (i.e. if there is other information to be included
in the model rvc file).

The supplied file in ff should be a csv file consistent with the format from the
Raven-generated ReservoirStages.csv file. External observations of reservoirs may be used
given that the csv file follows the same format.

The initial_percent must be between 0 and 1, so that the
initial stage is not less than the dry stage or greater than the maximum.
}
\examples{
ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")

# set initial conditions at 40\% capacity, view file
tf <- file.path(tempdir(), "modelname.rvc")
rvn_rvc_res(ff, initial_percent=0.4, output=tf)
readLines(tf)

}
\seealso{
\code{\link{rvn_res_read}} for reading in the ReservoirStages.csv file
}
