% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvc_write.R
\name{rvn_rvc_write}
\alias{rvn_rvc_write}
\title{Write Raven Initial Condition (rvc) file}
\usage{
rvn_rvc_write(
  filename,
  initHRU,
  init_date,
  description = "Generated by RavenR rvn_rvc_write",
  author = NULL
)
}
\arguments{
\item{filename}{filepath of rvc file to write to (with .rvc extension)}

\item{initHRU}{dataframe of initial conditions for state variables (columns) for each HRU (rows).
columns must be valid SV names and there must be an explicit column of HRU ids named 'HRU'.}

\item{init_date}{datetime of model start}

\item{description}{(optional) Description added after file header}

\item{author}{(optional) Name of author, to be printed in file header.}
}
\value{
\item{TRUE}{return \code{TRUE} if the function is executed properly}
}
\description{
Given initial conditions for state variables at HRUs, generates a rvc file
}
\examples{
# Create an initial condition HRU table where SOIL[0] is 0.5mm for all HRUs
# Check.names is set to FALSE to allow for brackets in the column name
initHRU <- data.frame('HRU'=1:10, 'SOIL[0]'=0.5, check.names=FALSE)
model_start = as.Date('2001-10-01')

# Generate RVC file
rvn_rvc_write(filename = file.path(tempdir(), "New.rvc"),
              initHRU = initHRU,
              init_date = model_start,
              author = 'Harry Potter')
}
\seealso{
\code{\link{rvn_rvc_res}}
\code{\link{rvn_rvc_from_custom_output}}
}
\author{
Leland Scantlebury
}
