% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_res_plot.R
\name{rvn_res_plot}
\alias{rvn_res_plot}
\title{Plot Reservoir Stage}
\usage{
rvn_res_plot(
  sim = NULL,
  obs = NULL,
  precip = NULL,
  prd = NULL,
  winter_shading = FALSE,
  wsdates = c(12, 1, 3, 31)
)
}
\arguments{
\item{sim}{time series object of simulated stage}

\item{obs}{time series object of observed stage}

\item{precip}{time series object of precipitation}

\item{prd}{period to use in plotting}

\item{winter_shading}{optionally adds shading for winter months (default \code{FALSE})}

\item{wsdates}{integer vector of winter shading period dates (see details)}
}
\value{
\item{p1}{returns ggplot plot object}
}
\description{
Creates a reservoir stage plot for the supplied stage series.
}
\details{
Creates a reservoir stage plot using the supplied time series;
any series not supplied will not be plotted. If the precip time series is
supplied, the secondary y axis will be used to plot the precip time series.

The function assumes that the supplied time series have the same length and
duration in time. If this is not true, then the defined period or period
calculated from the first available stage series will be used to determine
the plotting limits in time. If the data is used directly from Raven output,
this is not a concern. The supplied time series should be in xts format,
which again can be obtained directly by using the \code{\link{rvn_res_extract}} function.

The winter_shading argument will add a transparent grey shading for the
December 1st to March 31st period in each year that is plotted (or other
period specified by wsdates).

wsdates is formatted as c(winter start month, winter start day, winter end month, winter end day).
}
\examples{

# read in sample reservoir file
ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")
rvn_res_read(ff) \%>\%
rvn_res_extract(subs="sub36", res=.) -> mystage
sim <- mystage$sim
obs <- mystage$obs
precip <- rvn_res_read(ff)$res$precip

# create a nice reservoir stage plot
rvn_res_plot(sim,obs)

# create a reservoir stage plot with precip as well
rvn_res_plot(sim,obs,precip=precip)

# create a reservoir stage plot with precip as well for a specific subperiod
prd <- "2003-10-01/2005-10-01"
rvn_res_plot(sim,obs,precip=precip,prd=prd)

# add winter shading
rvn_res_plot(sim,obs,precip=precip, winter_shading=TRUE)

}
\seealso{
\code{\link{rvn_hyd_read}} for reading in the Hydrographs.csv file, and
\code{\link{rvn_res_extract}} to extract time series from Raven objects
}
