#' @title Hydrograph Data from Raven
#'
#' @description
#' A dataset formatted to the xts package, read in by the hyd.read function.
#' The dataset contains the typical columns from the Raven outputted
#' Hydrographs.csv file, available for download in the Raven Tutorials
#' (linked below).
#'
#'@format rvn_hydrograph_data is a data frame with two object
#' \describe{
#'   \item{hyd}{simulated and observed flows from Raven model}
#'   \item{units}{units associated with each variable in hyd}
#'   \item{obs.flag}{flag for each column indicating whether it is observed data or not}
#' }
#'
#' rvn_hydrograph_data$hyd is an xts (time series) object with 731 rows and
#' 5 variables, with data from 2002-10-01 to 2004-09-30. More details on
#' the Hydrographs.csv output can be found in the Raven manual.
#' \itemize{
#'  \item{precip}{ - precipitation time series}
#'  \item{Sub36}{ - outflows from subbasin 36 in Nith model}
#'  \item{Sub36_obs}{ - observed outflows from subbasin 36}
#'  \item{Sub43}{ - outflows from subbasin 43 in Nith model}
#'  \item{Sub43_obs}{ - observed outflows from subbasin 43}
#' }
#'
#' The Nith River model can be downloaded from the Raven Tutorials (tutorial #2)
#' \url{http://raven.uwaterloo.ca/Downloads.html}
#'
#' @seealso \code{\link{rvn_custom_read}} for reading in custom output files
#' @seealso \code{\link{rvn_custom_output_plot}} for plotting custom output
#'
#'
"rvn_hydrograph_data"
