/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class Generator
implements Serializable {
    private boolean m_Debug = false;
    private Instances m_Format = null;
    private String m_RelationName = "";
    private int m_NumAttributes = 10;
    private int m_NumClasses = 2;
    private int m_NumExamples = 100;
    private int m_NumExamplesAct = 0;
    private PrintWriter m_Output = null;

    abstract Instances defineDataFormat() throws Exception;

    abstract Instance generateExample() throws Exception;

    abstract Instances generateExamples() throws Exception;

    abstract String generateFinished() throws Exception;

    abstract boolean getSingleModeFlag() throws Exception;

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setRelationName(String string) {
        if (string.length() == 0) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            String[] stringArray = this.getGenericOptions();
            for (n = 0; n < stringArray.length; ++n) {
                stringBuffer = stringBuffer.append(stringArray[n].trim());
            }
            if (this instanceof OptionHandler) {
                stringArray = ((OptionHandler)((Object)this)).getOptions();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer = stringBuffer.append(stringArray[n].trim());
                }
            }
            this.m_RelationName = stringBuffer.toString();
        } else {
            this.m_RelationName = string;
        }
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public void setNumClasses(int n) {
        this.m_NumClasses = n;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public void setNumExamples(int n) {
        this.m_NumExamples = n;
    }

    public int getNumExamples() {
        return this.m_NumExamples;
    }

    public void setNumAttributes(int n) {
        this.m_NumAttributes = n;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public void setNumExamplesAct(int n) {
        this.m_NumExamplesAct = n;
    }

    public int getNumExamplesAct() {
        return this.m_NumExamplesAct;
    }

    public void setOutput(PrintWriter printWriter) {
        this.m_Output = printWriter;
    }

    public PrintWriter getOutput() {
        return this.m_Output;
    }

    protected void setFormat(Instances instances) {
        this.m_Format = new Instances(instances, 0);
    }

    protected Instances getFormat() {
        Instances instances = new Instances(this.m_Format, 0);
        return instances;
    }

    protected String toStringFormat() {
        if (this.m_Format == null) {
            return "";
        }
        return this.m_Format.toString();
    }

    public static void makeData(Generator generator, String[] stringArray) throws Exception {
        String string;
        int n;
        PrintWriter printWriter = null;
        try {
            Generator.setOptions(generator, stringArray);
        }
        catch (Exception exception) {
            String string2 = "";
            if (generator instanceof OptionHandler) {
                string2 = generator.listSpecificOptions(generator);
            }
            String string3 = Generator.listGenericOptions(generator);
            throw new Exception('\n' + exception.getMessage() + string2 + string3);
        }
        generator.setFormat(generator.defineDataFormat());
        printWriter = generator.getOutput();
        printWriter.println("% ");
        printWriter.print("% " + generator.getClass().getName() + " ");
        String[] stringArray2 = generator.getGenericOptions();
        for (n = 0; n < stringArray2.length; ++n) {
            printWriter.print(stringArray2[n] + " ");
        }
        stringArray2 = ((OptionHandler)((Object)generator)).getOptions();
        for (n = 0; n < stringArray2.length; ++n) {
            printWriter.print(stringArray2[n] + " ");
        }
        printWriter.println("\n%");
        n = generator.getSingleModeFlag() ? 1 : 0;
        if (n != 0) {
            printWriter.println(generator.toStringFormat());
            for (int i = 0; i < generator.getNumExamplesAct(); ++i) {
                Instance instance = generator.generateExample();
                printWriter.println(instance);
            }
        } else {
            Instances instances = generator.generateExamples();
            printWriter.println(instances);
        }
        if ((string = generator.generateFinished()).length() > 0) {
            printWriter.println(string);
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    private String listSpecificOptions(Generator generator) {
        String string = "";
        if (generator instanceof OptionHandler) {
            string = string + "\nData Generator options:\n\n";
            Enumeration enumeration = ((OptionHandler)((Object)generator)).listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                string = string + option.synopsis() + '\n' + option.description() + "\n";
            }
        }
        return string;
    }

    private static void setOptions(Generator generator, String[] stringArray) throws Exception {
        String string;
        String string2;
        boolean bl = false;
        String string3 = new String("");
        bl = Utils.getFlag('h', stringArray);
        if (Utils.getFlag('d', stringArray)) {
            generator.setDebug(true);
        }
        String string4 = Utils.getOption('r', stringArray);
        string3 = Utils.getOption('o', stringArray);
        String string5 = Utils.getOption('c', stringArray);
        if (string5.length() != 0) {
            generator.setNumClasses(Integer.parseInt(string5));
        }
        if ((string2 = Utils.getOption('n', stringArray)).length() != 0) {
            generator.setNumExamples(Integer.parseInt(string2));
            generator.setNumExamplesAct(Integer.parseInt(string2));
        }
        if ((string = Utils.getOption('a', stringArray)).length() != 0) {
            generator.setNumAttributes(Integer.parseInt(string));
        }
        if (generator instanceof OptionHandler) {
            ((OptionHandler)((Object)generator)).setOptions(stringArray);
        }
        generator.setRelationName(string4);
        Utils.checkForRemainingOptions(stringArray);
        if (bl) {
            throw new Exception("Help requested.\n");
        }
        PrintWriter printWriter = string3.length() != 0 ? new PrintWriter(new FileOutputStream(string3)) : new PrintWriter(System.out);
        generator.setOutput(printWriter);
    }

    private static String listGenericOptions(Generator generator) {
        String string = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-a <number of attributes>\n\tThe number of attributes the produced dataset should have.\n-c <number of classes>\n\tThe number of classes the produced dataset should have.\n-n <number of examples>\n\tThe number of examples the produced dataset should have.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied the instances will be written to stdout.\n";
        return string;
    }

    private String[] getGenericOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        String string = this.getRelationName();
        if (string.length() > 0) {
            stringArray[n++] = "-r";
            stringArray[n++] = "" + this.getRelationName();
        }
        stringArray[n++] = "-a";
        stringArray[n++] = "" + this.getNumAttributes();
        stringArray[n++] = "-c";
        stringArray[n++] = "" + this.getNumClasses();
        stringArray[n++] = "-n";
        stringArray[n++] = "" + this.getNumExamples();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }
}

