% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCollection.R
\docType{methods}
\name{exec}
\alias{exec}
\alias{exec,RTestCollection-method}
\title{Tests imported Test Cases}
\usage{
\S4method{exec}{RTestCollection}(object, test.TCs = NULL,
  test.for = NULL, out.fPath = NULL, open = TRUE, ...)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCollection-class}} object.}

\item{test.TCs}{(\code{character}) Vector with the TCs to be executed or NULL if all
all TCs of the collection should be tested.}

\item{test.for}{(\code{vector(character)}) Specification for which elements to test,
NULL for test all elements}

\item{out.fPath}{(\code{character}) Path to output file.}

\item{open}{(\code{logical}) Should the generated file be opened (TRUE) or not
(FALSE) after report generation.}

\item{...}{(\code{logical}) Additional parameters passed to function
\code{writeExecSummary.html}.}
}
\description{
Tests imported Test Cases
}
\examples{

testCollection <- new("RTestCollection",
   project.name    = "RTest Vignette",
   project.details = "Example test exectuion",
   tester          = "Example tester",
   test.start      = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S"))

TCDir <- list.dirs(find.package("RTest"),recursive = TRUE) \%>\%
   grep(pattern = "xml-templates", value = TRUE)

message("Test Adapter being used is defined in Function")
message("test.RTest.test_returnValue_data.frame_cellbycell")

testCollection <- importTCsFromDir(testCollection,
    xml.dPath = TCDir[1],f.pattern  = "RTest_TC-01.xml")

testCollection <- exec(testCollection)

outf <- tempfile(fileext=".html")
writeExecSummary.html(testCollection, out.fPath = outf,open = FALSE)

stopifnot(any(grepl("passed",readLines(outf))))

}
\seealso{
\code{\link{RTestCollection-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
