% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.xmlRead.R
\name{xmlReadData_to_list}
\alias{xmlReadData_to_list}
\title{Read an unidentified List of Data Types from TestCase params}
\usage{
xmlReadData_to_list(xmlItem)
}
\arguments{
\item{xmlItem}{Object of class \code{XMLNode} that defines a list
   of xmlTags that contain just elements defined in
RTest XSD (list, variable, text, data.frame, vector)}
}
\value{
args (\code{list}) All the elements named by their tag and containing 
		the value defined in the xml
}
\description{
Read an unidentified List of Data Types from TestCase params
}
\examples{
data <- '<mylist>

<inputitem1>
<col-defs>
  <coldef name="Column1" type="character"/>
  <coldef name="Column2" type="numeric"/>
</col-defs>
<row name="1"><cell>ID1</cell><cell>1</cell></row>
<row name="2"><cell>ID2</cell><cell>2.1</cell></row>
<row name="3"><cell>ID3</cell><cell>3.1</cell></row>
</inputitem1>
<inputitem2 type="numeric"><element>1</element><element>2</element></inputitem2>

</mylist>
'
item <- XML::xmlRoot(XML::xmlParse(data,asText=TRUE))
value <- RTest::xmlReadData_to_list(item)

stopifnot(names(value)[1]=="inputitem1")
stopifnot(names(value)[2]=="inputitem2")
stopifnot(length(value[[2]])==2)
}
\author{
Sebastian Wolf <sebastian.wolf@roche.com>
}
