% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MangatSingh.R
\name{MangatSingh}
\alias{MangatSingh}
\title{Mangat-Singh model}
\usage{
MangatSingh(z,p,t,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p}{proportion of marked cards with the sensitive attribute in the second box}

\item{t}{proportion of marked cards with "True" in the first box}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Mangat-Singh model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence interval through the Mangat-Singh model.
The function can also return the transformed variable.
The Mangat-Singh model was proposed by Mangat and Singh in 1990.
}
\details{
In the Mangat-Singh model, the sampled person is offered two boxes of cards. In the first box a known proportion \eqn{t,(0<t<1)} of cards is marked "True" and the
remaining ones are marked "RR". One card is to be drawn, observed and returned to the box. If the card drawn is marked "True", then the respondent should respond "Yes"
if he/she belongs to the sensitive category, otherwise "No". If the card drawn is marked "RR", then the respondent must use the second box and draw a card from it.
This second box contains a proportion \eqn{p,(0<p<1,p\neq 0.5)} of cards marked \eqn{A} and the remaining ones are marked \eqn{A^c}. If the card drawn from the second
box matches his/her status as related to the stigmatizing characteristic, he/she must respond "Yes", otherwise "No".
The randomized response from a person labelled \eqn{i} is assumed to be:
\deqn{z_i=\left \{\begin{array}{lcc}
y_i & \textrm{if a card marked "True" is drawn from the first box}\\
I_i & \textrm{if a card marked "RR" is drawn}
\end{array}
\right .}
\deqn{I_i=\left \{\begin{array}{lcc}
1 & \textrm{if the "card type" } A \textrm{ or } A^c  \textrm{ "matches" the genuine trait } A \textrm{ or } A^c\\
0 & \textrm{if a "mismatch" is observed}
\end{array}
\right .}
The transformed variable is \eqn{r_i=\frac{z_i-(1-t)(1-p)}{t+(1-t)(2p-1)}} and the estimated variance is \eqn{\widehat{V}_R(r_i)=r_i(r_i-1)}.
}
\examples{
N=802
data(MangatSinghData)
dat=with(MangatSinghData,data.frame(z,Pi))
p=0.7
t=0.55
cl=0.95
MangatSingh(dat$z,p,t,dat$Pi,"mean",cl,N)
}
\references{
Mangat, N.S., Singh, R. (1990).
\emph{An alternative randomized response procedure.}
 Biometrika, 77, 439-442.
}
\seealso{
\code{\link{MangatSinghData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{MangatSingh}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

