% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{results_barplot}
\alias{results_barplot}
\title{results_barplot}
\usage{
results_barplot(
  data,
  sel.Gene = "all",
  bar.width = 0.8,
  signif.show = FALSE,
  signif.labels,
  signif.length = 0.2,
  signif.dist = 0.2,
  faceting = FALSE,
  facet.row,
  facet.col,
  y.exp.low = 0.1,
  y.exp.up = 0.2,
  angle = 0,
  rotate = FALSE,
  colors = c("#66c2a5", "#fc8d62"),
  x.axis.title = "",
  y.axis.title = "value",
  axis.title.size = 11,
  axis.text.size = 10,
  legend.text.size = 11,
  legend.title = "Group",
  legend.title.size = 11,
  legend.position = "top",
  plot.title = "",
  plot.title.size = 14,
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "results_barplot"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{bar.width}{Numeric: width of bars.}

\item{signif.show}{Logical: if TRUE, labels for statistical significance will be added to the plot. Default to FALSE.}

\item{signif.labels}{Character vector with statistical significance labels (e.g. "ns.","***", etc.). The number
of elements must be equal to the number of genes used for plotting. All elements in the vector must be different; therefore,
symmetrically white spaces to repeated labels must be add to the same labels, e.g. "ns.", " ns. ", "  ns.  ".}

\item{signif.length}{Numeric: length of horizontal bars under statistical significance labels, values from 0 to 1.}

\item{signif.dist}{Numeric: distance between errorbar and statistical significance labels.
Can be in y axis units (if faceting = FALSE) or fraction of y axis value reached by errorbar (mean + sd value) (if faceting = TRUE).}

\item{faceting}{Logical: if TRUE (default), plot will be drawn with facets with free scales.}

\item{facet.row, facet.col}{Integer: number of rows and columns to arrange facets.}

\item{y.exp.low, y.exp.up}{Numeric: space between data on the plot and lower or upper axis. Useful to add extra space for statistical significance labels when faceting = TRUE.}

\item{angle}{Integer: value of angle in which names of genes are displayed. Default to 0.}

\item{rotate}{Logical: if TRUE, boxplots will be arranged horizontally. Default to FALSE.}

\item{colors}{Character vector length of one (when by.group = FALSE) or two (when by.group = TRUE), containing colors for groups.
The numbers of colors must be equal to the number of groups. Default to c("#66c2a5", "#fc8d62").}

\item{x.axis.title}{Character: title of x axis. Default to "Gene".}

\item{y.axis.title}{character: title of y axis. Default to "value".}

\item{axis.title.size}{Integer: font size of axis titles. Default to 11.}

\item{axis.text.size}{Integer: font size of axis text. Default to 10.}

\item{legend.text.size}{Integer: font size of legend text. Default to 11.}

\item{legend.title}{Character: title of legend. Default to "Group".}

\item{legend.title.size}{Integer: font size of legend title. Default to 11.}

\item{legend.position}{Position of the legend, can be "top" (default), "right", "bottom", "left", or "none" (no legend).
See description for legend.position in ggplot2::theme() function.}

\item{plot.title}{Character: title of plot. Default to "".}

\item{plot.title.size}{Integer: font size of plot title. Default to 14.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "results_barplot".}
}
\value{
Object with plot. Created plot will be also displayed on graphic device.
}
\description{
This function creates a barplot that illustrate mean and sd values of genes.
Faceting and adding custom labels of statistical significance are available.
This function is useful to present results for finally selected genes.
}
\examples{
library(ggsignif)
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
data.dCtF <- filter_transformed_data(data.dCt, remove.Sample = c("Control11"))
results_barplot(data.dCtF,
                sel.Gene = c("Gene1","Gene16","Gene19","Gene20"),
                signif.labels = c("****","*","***"," * "),
                angle = 30,
                signif.dist = 1.05,
                facet.row = 1,
                facet.col = 4,
                y.exp.up = 0.1,
                y.axis.title = bquote(~2^-dCt))

}
