% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{corr_gene}
\alias{corr_gene}
\title{corr_gene}
\usage{
corr_gene(
  data,
  sel.Gene = "all",
  type = "upper",
  method = "pearson",
  add.coef = "black",
  order = "hclust",
  hclust.method = "average",
  size = 0.6,
  coef.size = 0.6,
  p.adjust.method = "BH",
  save.to.tiff = FALSE,
  dpi = 600,
  width = 15,
  height = 15,
  name.tiff = "corr_genes",
  save.to.txt = FALSE,
  name.txt = "corr_genes"
)
}
\arguments{
\item{data}{Object returned from make_Ct_ready() or delta_Ct() functions.}

\item{sel.Gene}{Character vector with names of genes to include, or "all" (default) to use all genes.}

\item{type}{Character: type of displayed matrix, must be one of the 'full' (full matrix), 'upper' (upper triangular, default) or 'lower' (lower triangular).}

\item{method}{Character: type of correlations to compute, can be "pearson" (default) for Pearson's correlation coefficients
or "spearman" for Spearman's rank correlation coefficients.}

\item{add.coef}{If correlation coefficients should be add to the plot, specify color of coefficients (default to "black").
If NULL, correlation coefficients will not be printed.}

\item{order}{Character: method used for ordering the correlation matrix, inherited from corrplot::corrplot() function.
Must be one of the "original" (original order), "AOE" (angular order of the eigenvectors), "FPC" (first principal component order),
"hclust" (hierarchical clustering order, default), or "alphabet" (alphabetical order).}

\item{hclust.method}{Character: name of method used for hclust agglomeration, must be one of "ward", ward.D",
"ward.D2", "single", "complete", "average" (default), "mcquitty", "median" or "centroid".}

\item{size}{Numeric: size of variable names and numbers in legend. Default to 0.6.}

\item{coef.size}{Numeric: size of correlation coefficients. Default to 0.6.}

\item{p.adjust.method}{Character: p value correction method for multiple testing, one of the "holm", "hochberg", "hommel",
"bonferroni", "BH" (default), "BY","fdr", or "none". See documentation for stats::p.adjust() function for details.}

\item{save.to.tiff}{Logical: if TRUE, plot will be saved as .tiff file. Default to FALSE.}

\item{dpi}{Integer: resolution of saved .tiff file. Default to 600.}

\item{width}{Numeric: width (in cm) of saved .tiff file. Default to 15.}

\item{height}{Numeric: height (in cm) of saved .tiff file. Default to 15.}

\item{name.tiff}{Character: name of saved .tiff file, without ".tiff" name of extension. Default to "corr_genes".}

\item{save.to.txt}{Logical: if TRUE, correlation results (sorted by absolute values of correlation coefficients in descending order)
will be saved to .txt file. Default to FALSE.}

\item{name.txt}{character: name of saved .txt file, without ".txt" name of extension.. Default to "corr_genes".}
}
\value{
Plot illustrating correlation matrix (displayed on the graphic device) and
data frame with computed correlation coefficients and p values.
}
\description{
This function performs correlation analysis of genes based on the data, useful to gain insight into relationships between analyzed genes.
}
\examples{
library(tidyverse)
library(Hmisc)
library(corrplot)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
corr.genes <- corr_gene(data.dCt)
head(corr.genes)

}
