% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nifti.R
\name{retrieveNifti}
\alias{retrieveNifti}
\title{Obtain an internal NIfTI representation of an object}
\usage{
retrieveNifti(object)
}
\arguments{
\item{object}{Any suitable object (see Details).}
}
\value{
An internal image.
}
\description{
This function converts filenames, arrays and other image classes into an
object of class \code{"internalImage"}.
}
\details{
If the \code{object} has an internal NIfTI pointer, that will be retrieved
directly. Otherwise, if it is a string, it will be taken to be a filename.
If it looks like a \code{"nifti"} object (from package \code{oro.nifti}),
or an \code{"MriImage"} object (from package \code{tractor.base}), a
conversion will be attempted. A list will be assumed to be of the form
produced by \code{\link{niftiHeader}}. Finally, a numeric array or matrix
will be converted using default image parameters.
}
\seealso{
\code{\link{readNifti}}, \code{\link{updateNifti}}
}
\author{
Jon Clayden <code@clayden.org>
}
