% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{hourdiff_range_thresholds}
\alias{hourdiff_range_thresholds}
\title{Inspect effects of thresholds on matches over time}
\usage{
hourdiff_range_thresholds(g, breaks = 20, hourdiff_range = c(0, Inf),
  min_weight = NA, min_hourdiff = NA, max_hourdiff = NA)
}
\arguments{
\item{g}{The output of newsflow.compare (either as "igraph" or "edgelist")}

\item{breaks}{The number of breaks for the weight threshold}

\item{hourdiff_range}{The time period (hourdiff range) in which the match 'should' occur.}

\item{min_weight}{Optionally, filter out all value below the given weight}

\item{min_hourdiff}{the lowest possible hourdiff value. This is used to estimate noise. If not specified, will be estimated based on data.}

\item{max_hourdiff}{the highest possible hourdiff value.}
}
\value{
Nothing... just plots
}
\description{
If it can be assumed that matches should only occur within a given time range (e.g., event data should match news items after the event occured)
a low effort validation can be obtained by looking at whether the matches only occur within this time range. 
This function plots the percentage of matches within a given time range (hourdiff) for different thresholds of the weight column.
This can be used to determine a good threshold.
}
