% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getPaths.R
\name{getPaths}
\alias{getPaths}
\title{Retrieve Paths with Cypher Queries}
\usage{
getPaths(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A list of path objects.
}
\description{
Deprecated. Use \code{\link{cypherToList}}. Retrieve paths from the graph with a Cypher query.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice", age = 23)
bob = createNode(graph, "Person", name = "Bob", age = 22)
charles = createNode(graph, "Person", name = "Charles", age = 25)

createRel(alice, "KNOWS", bob)
createRel(alice, "KNOWS", charles)

query = "MATCH p = (:Person {name:'Alice'})-[:KNOWS]->(:Person) RETURN p"

paths = getPaths(graph, query)

lapply(paths, startNode)
lapply(paths, endNode)
}
}
\seealso{
\code{\link{getSinglePath}}
}

