\name{example.data}
\alias{example.data}
\docType{data}
\title{Simulated data from Cormack-Jolly-Seber model}
\description{
A simulated data set from CJS model to demonstrate use of grouping variables and individual covariates
in an analysis of a \code{mark} model. The true model for the simulated data is S(age+year)p(year).
}
\usage{data(example.data)}
\format{
  A data frame with 6000 observations on the following 5 variables.
  \describe{
    \item{ch}{a character vector}
    \item{weight}{a numeric vector}
    \item{age}{a factor with levels \code{1} \code{2} \code{3}}
    \item{sex}{a factor with levels \code{F} \code{M}}
    \item{region}{a factor with levels \code{1} \code{2} \code{3} \code{4}}
  }
}
\details{
The \code{weight}, \code{age} and \code{region} are static variables that are defined based on the values when the animal was
released. \code{age} is a factor variable representing an age level.  The actual ages (at time of release) are 0,1,2 for the 3 levels
respectively.    
}
\examples{
data(example.data)
run.example=function()
{
PhiTime=list(formula=~time)
pTimec=list(formula=~time,fixed=list(time=7,value=1))
pTime=list(formula=~time)
PhiAge=list(formula=~age)
Phidot=list(formula=~1)
PhiweightTime=list(formula=~weight+time)
PhiTimeAge=list(formula=~time+age)
mod1=mark(example.data,groups=c("sex","age","region"),
                           initial.ages=c(0,1,2))
mod2=mark(example.data,model.parameters=list(p=pTimec,Phi=PhiTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod3=mark(example.data,model.parameters=list(Phi=Phidot,p=pTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod4=mark(example.data,model.parameters=list(Phi=PhiTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod5=mark(example.data,model.parameters=list(Phi=PhiTimeAge),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod6=mark(example.data,model.parameters=list(Phi=PhiAge,p=pTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod7=mark(example.data,model.parameters=list(p=pTime,Phi=PhiweightTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
mod8=mark(example.data,model.parameters=list(Phi=PhiTimeAge,p=pTime),
          groups=c("sex","age","region"),initial.ages=c(0,1,2))
return(collect.models())
}
example.results=run.example()
}
\keyword{datasets}
