% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glrlm.R
\encoding{UTF-8}
\name{glrlm}
\alias{glrlm}
\title{Creates gray-level run length matrix from RIA image}
\usage{
glrlm(RIA_data_in, off_right = 1, off_down = 0, off_z = 0,
  use_type = "single", use_orig = FALSE, use_slot = NULL,
  save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}.}

\item{off_right}{integer, positive values indicate to look to the right, negative values
indicate to look to the left, while 0 indicates no offset in the X plane.}

\item{off_down}{integer, positive values indicate to look to the right, negative values
indicate to look to the left, while 0 indicates no offset in the Y plane.}

\item{off_z}{integer, positive values indicate to look to the right, negative values
indicate to look to the left, while 0 indicates no offset in the Z plane.}

\item{use_type}{string, can be \emph{"single"} which runs the function on a single image,
which is determined using \emph{"use_orig"} or \emph{"use_slot"}. \emph{"discretized"}
takes all datasets in the \emph{RIA_image$discretized} slot and runs the analysis on them.}

\item{use_orig}{logical, indicating to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$discretized$ep_4}, then \emph{use_slot} should be
\emph{discretized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$glcm} to save results to.
If left empty, then it will be automatically determined based on the
last entry of \emph{RIA_image$log$events}.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the GLRLM.
}
\description{
Creates gray-level run length matrix (GLRLM) from \emph{RIA_image}.
GLRLM assesses the spatial relation of voxels to each other by investigating how many times
same value voxels occur next to each other in a given direction. By default the \emph{$modif}
image will be used to calculate GLRLMs. If \emph{use_slot} is given, then the data
present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{glrlm} slot. The name of the subslot is determined
by the supplied string in \emph{save_name}, or is automatically generated by RIA. \emph{off_right},
\emph{off_down} and \emph{off_z} logicals are used to indicate the direction of the runs.
}
\examples{
\dontrun{
#Discretize loaded image and then calculate GLRLM matrix of RIA_image$modif
RIA_image <- discretize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- glrlm(RIA_image, use_orig = FALSE, verbose_in = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- glrlm(RIA_image, use_orig = FALSE, use_slot = "discretized$ep_4",
off_right = 1, off_down = 1, off_z = 0)

#Batch calculation of GLRLM matrices on all discretized images
RIA_image <- glrlm(RIA_image, use_type = "discretized",
off_right = 1, off_down = 1, off_z = 0)
}

}
\references{
Mary M. Galloway et al.
Texture analysis using gray level run lengths.
Computer Graphics and Image Processing. 1975; 4:172-179.
DOI: 10.1016/S0146-664X(75)80008-6
\url{https://www.sciencedirect.com/science/article/pii/S0146664X75800086/}

Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
