/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLogAppender;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TaskLog {
    private static final Log LOG = LogFactory.getLog(TaskLog.class);
    static final String USERLOGS_DIR_NAME = "userlogs";
    private static final File LOG_DIR = new File(TaskLog.getBaseLogDir(), "userlogs").getAbsoluteFile();
    static LocalFileSystem localFS = null;
    static final List<LogName> LOGS_TRACKED_BY_INDEX_FILES;
    private static TaskAttemptID currentTaskid;
    private static Map<LogName, Long[]> logLengths;
    private static final String bashCommand = "bash";
    private static final String tailCommand = "tail";

    public static File getTaskLogFile(TaskAttemptID taskid, boolean isCleanup, LogName filter) {
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), filter.toString());
    }

    static String getRealTaskLogFilePath(String location, LogName filter) throws IOException {
        return FileUtil.makeShellPath(new File(location, filter.toString()));
    }

    static Map<LogName, LogFileDetail> getAllLogsFileDetails(TaskAttemptID taskid, boolean isCleanup) throws IOException {
        HashMap<LogName, LogFileDetail> allLogsFileDetails = new HashMap<LogName, LogFileDetail>();
        File indexFile = TaskLog.getIndexFile(taskid, isCleanup);
        BufferedReader fis = new BufferedReader(new FileReader(indexFile));
        String str = fis.readLine();
        if (str == null) {
            throw new IOException("Index file for the log of " + taskid + " doesn't exist.");
        }
        String loc = str.substring(str.indexOf("LOG_DIR:") + "LOG_DIR:".length());
        for (LogName filter : new LogName[]{LogName.DEBUGOUT, LogName.PROFILE}) {
            LogFileDetail l = new LogFileDetail();
            l.location = loc;
            l.length = new File(l.location, filter.toString()).length();
            l.start = 0L;
            allLogsFileDetails.put(filter, l);
        }
        str = fis.readLine();
        while (str != null) {
            LogFileDetail l = new LogFileDetail();
            l.location = loc;
            int idx = str.indexOf(58);
            LogName filter = LogName.valueOf(str.substring(0, idx).toUpperCase());
            str = str.substring(idx + 1);
            String[] startAndLen = str.split(" ");
            l.start = Long.parseLong(startAndLen[0]);
            l.length = Long.parseLong(startAndLen[1]);
            allLogsFileDetails.put(filter, l);
            str = fis.readLine();
        }
        fis.close();
        return allLogsFileDetails;
    }

    private static File getTmpIndexFile(TaskAttemptID taskid, boolean isCleanup) {
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), "log.tmp");
    }

    static File getIndexFile(TaskAttemptID taskid, boolean isCleanup) {
        return new File(TaskLog.getAttemptDir(taskid, isCleanup), "log.index");
    }

    static String getBaseLogDir() {
        return System.getProperty("hadoop.log.dir");
    }

    static File getAttemptDir(TaskAttemptID taskid, boolean isCleanup) {
        String cleanupSuffix = isCleanup ? ".cleanup" : "";
        return new File(TaskLog.getJobDir(taskid.getJobID()), taskid + cleanupSuffix);
    }

    static void writeToIndexFile(String logLocation, TaskAttemptID currentTaskid, boolean isCleanup, Map<LogName, Long[]> lengths) throws IOException {
        File tmpIndexFile = TaskLog.getTmpIndexFile(currentTaskid, isCleanup);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpIndexFile, false));
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeBytes("LOG_DIR:" + logLocation + "\n");
        for (LogName logName : LOGS_TRACKED_BY_INDEX_FILES) {
            Long[] lens = lengths.get((Object)logName);
            dos.writeBytes(logName.toString() + ":" + lens[0].toString() + " " + Long.toString(lens[1] - lens[0]) + "\n");
        }
        dos.close();
        File indexFile = TaskLog.getIndexFile(currentTaskid, isCleanup);
        Path indexFilePath = new Path(indexFile.getAbsolutePath());
        Path tmpIndexFilePath = new Path(tmpIndexFile.getAbsolutePath());
        if (localFS == null) {
            localFS = FileSystem.getLocal(new Configuration());
        }
        localFS.rename(tmpIndexFilePath, indexFilePath);
    }

    public static synchronized void syncLogs(String logLocation, TaskAttemptID taskid, boolean isCleanup) throws IOException {
        System.out.flush();
        System.err.flush();
        Enumeration allLoggers = LogManager.getCurrentLoggers();
        while (allLoggers.hasMoreElements()) {
            Logger l = (Logger)allLoggers.nextElement();
            Enumeration allAppenders = l.getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender a = (Appender)allAppenders.nextElement();
                if (!(a instanceof TaskLogAppender)) continue;
                ((TaskLogAppender)a).flush();
            }
        }
        for (LogName logName : LOGS_TRACKED_BY_INDEX_FILES) {
            if (currentTaskid != taskid) {
                TaskLog.logLengths.get((Object)((Object)logName))[0] = new File(logLocation, logName.toString()).length();
            }
            TaskLog.logLengths.get((Object)((Object)logName))[1] = new File(logLocation, logName.toString()).length();
        }
        if (currentTaskid != taskid) {
            if (currentTaskid != null) {
                LOG.info((Object)("Starting logging for a new task " + taskid + " in the same JVM as that of the first task " + logLocation));
            }
            currentTaskid = taskid;
        }
        TaskLog.writeToIndexFile(logLocation, taskid, isCleanup, logLengths);
    }

    public static long getTaskLogLength(JobConf conf) {
        return conf.getLong("mapred.userlog.limit.kb", 100L) * 1024L;
    }

    public static List<String> captureOutAndError(List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        return TaskLog.captureOutAndError(null, cmd, stdoutFilename, stderrFilename, tailLength, false);
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength) throws IOException {
        return TaskLog.captureOutAndError(setup, cmd, stdoutFilename, stderrFilename, tailLength, false);
    }

    @Deprecated
    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, String pidFileName) throws IOException {
        return TaskLog.captureOutAndError(setup, cmd, stdoutFilename, stderrFilename, tailLength, false, pidFileName);
    }

    @Deprecated
    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, boolean useSetsid, String pidFileName) throws IOException {
        return TaskLog.captureOutAndError(setup, cmd, stdoutFilename, stderrFilename, tailLength, useSetsid);
    }

    public static List<String> captureOutAndError(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, boolean useSetsid) throws IOException {
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        String mergedCmd = TaskLog.buildCommandLine(setup, cmd, stdoutFilename, stderrFilename, tailLength, useSetsid);
        result.add(mergedCmd.toString());
        return result;
    }

    static String buildCommandLine(List<String> setup, List<String> cmd, File stdoutFilename, File stderrFilename, long tailLength, boolean useSetSid) throws IOException {
        String stdout = FileUtil.makeShellPath(stdoutFilename);
        String stderr = FileUtil.makeShellPath(stderrFilename);
        StringBuffer mergedCmd = new StringBuffer();
        if (!Shell.WINDOWS) {
            mergedCmd.append(" export JVM_PID=`echo $$` ; ");
        }
        if (setup != null && setup.size() > 0) {
            mergedCmd.append(TaskLog.addCommand(setup, false));
            mergedCmd.append(";");
        }
        if (tailLength > 0L) {
            mergedCmd.append("(");
        } else if (ProcessTree.isSetsidAvailable && useSetSid && !Shell.WINDOWS) {
            mergedCmd.append("exec setsid ");
        } else {
            mergedCmd.append("exec ");
        }
        mergedCmd.append(TaskLog.addCommand(cmd, true));
        mergedCmd.append(" < /dev/null ");
        if (tailLength > 0L) {
            mergedCmd.append(" | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" ; exit $PIPESTATUS ) 2>&1 | ");
            mergedCmd.append(tailCommand);
            mergedCmd.append(" -c ");
            mergedCmd.append(tailLength);
            mergedCmd.append(" >> ");
            mergedCmd.append(stderr);
            mergedCmd.append(" ; exit $PIPESTATUS");
        } else {
            mergedCmd.append(" 1>> ");
            mergedCmd.append(stdout);
            mergedCmd.append(" 2>> ");
            mergedCmd.append(stderr);
        }
        return mergedCmd.toString();
    }

    public static String addCommand(List<String> cmd, boolean isExecutable) throws IOException {
        StringBuffer command = new StringBuffer();
        for (String s : cmd) {
            command.append('\'');
            if (isExecutable) {
                command.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                command.append(s);
            }
            command.append('\'');
            command.append(" ");
        }
        return command.toString();
    }

    public static List<String> captureDebugOut(List<String> cmd, File debugoutFilename) throws IOException {
        String debugout = FileUtil.makeShellPath(debugoutFilename);
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(bashCommand);
        result.add("-c");
        StringBuffer mergedCmd = new StringBuffer();
        mergedCmd.append("exec ");
        boolean isExecutable = true;
        for (String s : cmd) {
            if (isExecutable) {
                mergedCmd.append(FileUtil.makeShellPath(new File(s)));
                isExecutable = false;
            } else {
                mergedCmd.append(s);
            }
            mergedCmd.append(" ");
        }
        mergedCmd.append(" < /dev/null ");
        mergedCmd.append(" >");
        mergedCmd.append(debugout);
        mergedCmd.append(" 2>&1 ");
        result.add(mergedCmd.toString());
        return result;
    }

    public static File getUserLogDir() {
        return LOG_DIR;
    }

    public static File getJobDir(JobID jobid) {
        return new File(TaskLog.getUserLogDir(), jobid.toString());
    }

    static {
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
        LOGS_TRACKED_BY_INDEX_FILES = Arrays.asList(LogName.STDOUT, LogName.STDERR, LogName.SYSLOG);
        logLengths = new HashMap<LogName, Long[]>();
        for (LogName logName : LOGS_TRACKED_BY_INDEX_FILES) {
            logLengths.put(logName, new Long[]{0L, 0L});
        }
    }

    static class Reader
    extends InputStream {
        private long bytesRemaining;
        private FileInputStream file;

        public Reader(TaskAttemptID taskid, LogName kind, long start, long end, boolean isCleanup) throws IOException {
            long result;
            Map<LogName, LogFileDetail> allFilesDetails = TaskLog.getAllLogsFileDetails(taskid, isCleanup);
            LogFileDetail fileDetail = allFilesDetails.get((Object)kind);
            long size = fileDetail.length;
            if (start < 0L) {
                start += size + 1L;
            }
            if (end < 0L) {
                end += size + 1L;
            }
            start = Math.max(0L, Math.min(start, size));
            end = Math.max(0L, Math.min(end, size));
            this.bytesRemaining = (end += fileDetail.start) - (start += fileDetail.start);
            this.file = new FileInputStream(new File(fileDetail.location, kind.toString()));
            for (long pos = 0L; pos < start; pos += result) {
                result = this.file.skip(start - pos);
                if (result >= 0L) continue;
                this.bytesRemaining = 0L;
                break;
            }
        }

        @Override
        public int read() throws IOException {
            int result = -1;
            if (this.bytesRemaining > 0L) {
                --this.bytesRemaining;
                result = this.file.read();
            }
            return result;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int bytes = this.file.read(buffer, offset, length = (int)Math.min((long)length, this.bytesRemaining));
            if (bytes > 0) {
                this.bytesRemaining -= (long)bytes;
            }
            return bytes;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min(this.bytesRemaining, (long)this.file.available());
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }

    public static enum LogName {
        STDOUT("stdout"),
        STDERR("stderr"),
        SYSLOG("syslog"),
        PROFILE("profile.out"),
        DEBUGOUT("debugout");

        private String prefix;

        private LogName(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }

    static class LogFileDetail {
        static final String LOCATION = "LOG_DIR:";
        String location;
        long start;
        long length;

        LogFileDetail() {
        }
    }
}

