/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.generalstring;

import cern.jet.random.Poisson;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.module.fitness.generalstring.SSSPMultiObjective;
import freak.module.fitness.generalstring.SSSPSingleObjective;
import freak.module.searchspace.GeneralStringGenotype;

public class SSSPGlobalMutation
extends Mutation {
    public int[] flipps;

    public SSSPGlobalMutation(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        FitnessFunction f = schedule.getRealFitnessFunction();
        if (!(f instanceof SSSPMultiObjective) && !(f instanceof SSSPSingleObjective)) {
            throw new UnsupportedEnvironmentException("Only works in connection with a SSSP fitness function.");
        }
    }

    protected Individual doMutation(Individual ind) {
        GeneralStringGenotype geno = (GeneralStringGenotype)((GeneralStringGenotype)ind.getGenotype()).clone();
        int[] gt = geno.getIntArray();
        int dimension = ((HasDimension)((Object)this.graph.getSchedule().getGenotypeSearchSpace())).getDimension();
        RandomElement re = this.graph.getSchedule().getRandomElement();
        Poisson pd = new Poisson(1.0, re);
        int steps = pd.nextInt() + 1;
        int i = 0;
        while (i < steps) {
            int max;
            int min;
            int pos = re.choose(0, dimension - 1);
            if (gt[pos] > pos) {
                min = pos;
                max = gt[pos];
            } else {
                min = gt[pos];
                max = pos;
            }
            int newValue = re.choose(0, dimension - 2);
            if (newValue >= min) {
                ++newValue;
            }
            if (newValue >= max) {
                // empty if block
            }
            gt[pos] = ++newValue;
            ++i;
        }
        return new Individual(this.graph.getSchedule(), geno, new Individual[]{ind});
    }

    public String getName() {
        return "SSSP Global Mutation";
    }

    public String getDescription() {
        return "This operator chooses first a random value k from the poisson distribution with parameter lambda = 1. Then, it performs k local mutations (see SSSPLocalMutation).";
    }
}

