/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.population.Genotype;
import freak.module.fitness.pointset.AbstractAdjust;
import freak.module.fitness.pointset.AbstractRobustRegressionFitness;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.fitness.pointset.util.ResidualHyperPlane;
import freak.module.searchspace.PointSetGenotype;
import java.util.Arrays;

public class LMSAdjust
extends AbstractAdjust {
    public void adjust(AbstractRobustRegressionFitness toBeAdjusted, Genotype genotype) {
        Object[] resCont = toBeAdjusted.getResiduals();
        Arrays.sort(resCont);
        double min = 0.0;
        int j = 0;
        int k = resCont.length / 2 + 1;
        int i = 0;
        while (i < resCont.length - k) {
            double dist = ((ResidualContainer)resCont[i + k]).squaredResidual - ((ResidualContainer)resCont[i]).squaredResidual;
            if (i == 0 || min > dist) {
                min = dist;
                j = i;
            }
            ++i;
        }
        double lms = (((ResidualContainer)resCont[j + k]).squaredResidual + ((ResidualContainer)resCont[j]).squaredResidual) / 2.0;
        ResidualHyperPlane hyperPlane = toBeAdjusted.getResidualHyperPlane();
        try {
            hyperPlane.getParameter().set(0, lms);
            hyperPlane.updateResiduals((ResidualContainer[])resCont, ((PointSetGenotype)genotype).getPoints());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        double[] resCont = new double[]{90.0, 93.0, 86.0, 92.0, 95.0, 83.0, 75.0, 40.0, 88.0, 80.0};
        Arrays.sort(resCont);
        double min = 0.0;
        int j = 0;
        int k = resCont.length / 2 + 1;
        int i = 0;
        while (i < resCont.length - k + 1) {
            double dist = resCont[i + k - 1] - resCont[i];
            if (i == 0 || min > dist) {
                min = dist;
                j = i;
            }
            ++i;
        }
        double lms = (resCont[j + k - 1] + resCont[j]) / 2.0;
        System.out.println(lms);
    }
}

