/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.HasMetric;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class BitString
extends AbstractSearchSpace
implements Configurable,
HasMetric,
HasDimension {
    private int dimension;

    public BitString(Schedule schedule) {
        super(schedule);
        this.dimension = 64;
    }

    public BitString(Schedule schedule, int dimension) {
        super(schedule);
        this.dimension = dimension;
    }

    public String getDescription() {
        return "The search space {0,1}^dimension.";
    }

    public String getName() {
        return "Bit String";
    }

    public double getSize() {
        return Math.pow(2.0, this.dimension);
    }

    public double getDistance(Genotype gt1, Genotype gt2) {
        BitStringGenotype bst1 = (BitStringGenotype)gt1;
        BitStringGenotype bst2 = (BitStringGenotype)gt2;
        if (bst1.size() != bst2.size()) {
            throw new RuntimeException("Size of both genotypes is not equal");
        }
        BitSet bsXOR = (BitSet)bst1.getBitSet().clone();
        bsXOR.xor(bst2.getBitSet());
        return bsXOR.cardinality();
    }

    public Genotype getRandomGenotype() {
        BitSet bs = new BitSet(this.dimension);
        RandomElement re = this.schedule.getRandomElement();
        if (re == null) {
            throw new NullPointerException("no random element");
        }
        int i = 0;
        while (i < this.dimension) {
            if (re.choose(2) == 1) {
                bs.set(i);
            }
            ++i;
        }
        return new BitStringGenotype(bs, this.dimension);
    }

    public String getLongDescriptionForDimension() {
        return "The number of bits in all bit strings.";
    }

    public void setPropertyDimension(Integer dim) {
        if (dim >= 1) {
            this.dimension = dim;
        }
    }

    public Integer getPropertyDimension() {
        return new Integer(this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }
}

