/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split;

import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.modulesupport.Configurable;
import freak.core.population.IndividualList;
import freak.core.population.Population;

public class Choice
extends Split
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private double probability = 0.5;

    public Choice(OperatorGraph graph) {
        super(graph);
        this.addOutPort();
        this.addOutPort();
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        Population empty = new Population(this.getOperatorGraph().getSchedule());
        if (this.getOperatorGraph().getSchedule().getRandomElement().uniform(0.0, 1.0) < this.probability) {
            return new IndividualList[]{input[0], empty};
        }
        return new IndividualList[]{empty, input[0]};
    }

    public Double getPropertyProbability() {
        return new Double(this.probability);
    }

    public void setPropertyProbability(Double probability) {
        if (probability > 1.0 || probability < 0.0) {
            return;
        }
        this.probability = probability;
    }

    public String getLongDescriptionForProbability() {
        return "The probability that the individuals will be routed to the first port.";
    }

    public String getDescription() {
        return "Choice routes all individuals either to the first or to the second outport, depending on an adjustable probability.";
    }

    public String getName() {
        return "Choice";
    }
}

