/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import freak.core.control.Schedule;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.DifferentNumberOfIndividualsException;
import freak.core.graph.GraphException;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import java.util.Iterator;

public class SeriationSelection
extends Selection
implements HasFloatingNumberOfInPorts,
CompatibleWithDifferentSearchSpaces {
    public SeriationSelection(OperatorGraph graph) {
        super(graph);
        this.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on single objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        int inports = this.getNumberOfInPorts();
        IndividualList[] output = new IndividualList[1];
        int inputsize = input[0].size();
        output[0] = new Population(this.graph.getSchedule(), inputsize);
        SingleObjectiveFitnessFunction eval = (SingleObjectiveFitnessFunction)this.graph.getSchedule().getFitnessFunction();
        int i = 1;
        while (i < inports) {
            if (inputsize != input[i].size()) {
                throw new DifferentNumberOfIndividualsException("All individual lists must have the same number of individuals.");
            }
            ++i;
        }
        Iterator[] it = new Iterator[inports];
        int i2 = 0;
        while (i2 < inports) {
            it[i2] = input[i2].iterator();
            ++i2;
        }
        i2 = 0;
        while (i2 < inputsize) {
            Individual theWinner = (Individual)it[0].next();
            double winnerFitness = eval.evaluate(theWinner, input[0]);
            int j = 1;
            while (j < inports) {
                Individual tmpI = (Individual)it[j].next();
                double tmpF = eval.evaluate(tmpI, input[0]);
                if (winnerFitness < tmpF) {
                    theWinner = tmpI;
                    winnerFitness = tmpF;
                }
                ++j;
            }
            output[0].addIndividual(theWinner);
            ++i2;
        }
        return output;
    }

    public String getName() {
        return "Seriation Selection";
    }

    public String getDescription() {
        return "Competes individuals of the same position of all InPorts.";
    }
}

