/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.modulesupport.inspector.Inspector;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.gui.ModuleList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PseudoFitness
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    private SingleObjectiveFitnessFunction fitness;

    public PseudoFitness(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
        if (schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction) {
            this.fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        }
    }

    public void initialize() {
        super.initialize();
        this.fitness.initialize();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
        this.fitness.testSchedule(schedule);
    }

    public String getName() {
        return "Pseudo-fitness Values";
    }

    public String getDescription() {
        return "Computes the fitness values of the invidiuals with respect to a pseudo fitness function.";
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double[] fitnessValues = new double[individuals.length];
        int i = 0;
        while (i < individuals.length) {
            Individual individual = (Individual)individuals[i].clone();
            individual.setLatestKnownFitnessValue(null);
            fitnessValues[i] = this.fitness.evaluate(individual, individualList);
            ++i;
        }
        this.updateViews(fitnessValues);
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }

    public Inspector getInspector() {
        Inspector panel = new Inspector(this);
        final ModuleList moduleList = new ModuleList();
        Module[] modules = new ModuleCollector(this.getSchedule()).getFitnessFunctions(this.getSchedule().getPhenotypeSearchSpace());
        ArrayList<Module> singleObjectives = new ArrayList<Module>();
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof SingleObjectiveFitnessFunction) {
                singleObjectives.add(modules[i]);
            }
            ++i;
        }
        modules = singleObjectives.toArray(new Module[singleObjectives.size()]);
        moduleList.setModules(modules, this.fitness);
        moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (moduleList.getSelectedValue() != null) {
                    PseudoFitness.this.fitness = (SingleObjectiveFitnessFunction)moduleList.getSelectedValue();
                }
            }
        });
        panel.setLayout(new BorderLayout());
        panel.add((Component)moduleList, "Center");
        return panel;
    }

    public void setPropertyPseudoFitnessFunction(SingleObjectiveFitnessFunction fitness) {
        this.fitness = fitness;
    }

    public SingleObjectiveFitnessFunction getPropertyPseudoFitnessFunction() {
        return this.fitness;
    }

    public String getShortDescriptionForPseudoFitnessFunction() {
        return "Pseudo-fitness function";
    }
}

