/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class HIFF
extends AbstractStaticSingleObjectiveFitnessFunction {
    public HIFF(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        int n = ((BitString)schedule.getPhenotypeSearchSpace()).getDimension();
        if ((double)Math.round(Math.log(n) / Math.log(2.0)) != Math.log(n) / Math.log(2.0)) {
            throw new UnsupportedEnvironmentException("Size of search space doesn\u00a5t match with fitness function (has to be 2^k)");
        }
    }

    public double evaluate(Genotype genotype) {
        BitSet set = ((BitStringGenotype)genotype).getBitSet();
        int n = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        double fitness = n;
        int range = n;
        int[] temp = new int[n];
        int k = 0;
        while (k < n) {
            temp[k] = set.get(k) ? 1 : 0;
            ++k;
        }
        while (range > 1) {
            k = 0;
            while (k < range / 2) {
                if (temp[2 * k] == temp[2 * k + 1] && temp[2 * k] != -1) {
                    temp[k] = temp[2 * k];
                    fitness += (double)(2 * n / range);
                } else {
                    temp[k] = -1;
                }
                ++k;
            }
            range /= 2;
        }
        return fitness;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int n = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        return (double)n * (Math.log(n) / Math.log(2.0) + 1.0);
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        BitSet bs = new BitSet(((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension());
        bs.set(0, ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension());
        return new BitStringGenotype(bs, ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension());
    }

    public String getName() {
        return "H-IFF";
    }

    public String getDescription() {
        return "There is a bit string of length n=2^k. All possible blocks with length powers of 2 are constructed and checked if their bits are all equal. If they are equal the length of the block is added to the fitness value. But these blocks has also to start at positions 2^j, for a j in the natural numbers.\r\nYou can think of this fitness function as a complete binary tree. Each node is a block as described above. The leaves are the bits itself (block of size 2^0=1) and the root is the complete bit string (block of size 2^k=dimension).";
    }
}

