/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient JGraph graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;

    void setView(CellView cellView) {
        if (cellView instanceof EdgeView) {
            if (this.view != cellView) {
                this.view = (EdgeView)cellView;
                this.installAttributes(this.view);
            }
        } else {
            this.view = null;
        }
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof EdgeView && jGraph != null) {
            this.graph = jGraph;
            this.focus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setView(cellView);
            return this;
        }
        return null;
    }

    public boolean intersects(Graphics graphics, CellView cellView, Rectangle rectangle) {
        if (cellView instanceof EdgeView && graphics != null && cellView != null) {
            this.setView(cellView);
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = graphics2D.hit(rectangle, this.view.getShape(), true);
            if (bl) {
                return true;
            }
            Rectangle rectangle2 = this.view.getLabelBounds();
            if (rectangle2 != null) {
                return rectangle2.intersects(rectangle);
            }
        }
        return false;
    }

    public Rectangle getBounds(CellView cellView) {
        if (cellView instanceof EdgeView && cellView != null) {
            this.setView(cellView);
            Rectangle rectangle = this.getPaintBounds(this.view);
            Rectangle rectangle2 = this.getLabelBounds(this.view);
            if (rectangle2 != null) {
                rectangle = rectangle.union(rectangle2);
            }
            int n = (int)Math.ceil(this.lineWidth);
            rectangle.x -= n;
            rectangle.y -= n;
            rectangle.width += 2 * n;
            rectangle.height += 2 * n;
            return rectangle;
        }
        return null;
    }

    public Rectangle getLabelBounds(EdgeView edgeView) {
        this.setView(edgeView);
        Point point = this.getLabelPosition(this.view);
        Dimension dimension = this.getLabelSize(this.view);
        if (point != null && dimension != null) {
            point.translate(-dimension.width / 2, -dimension.height / 2);
            return new Rectangle(point.x, point.y, dimension.width + 1, dimension.height + 1);
        }
        return null;
    }

    public Point getLabelPosition(EdgeView edgeView) {
        this.setView(edgeView);
        Rectangle rectangle = this.getPaintBounds(edgeView);
        Point point = edgeView.getLabelPosition();
        int n = 1000;
        Point point2 = edgeView.getPoint(0);
        Point point3 = edgeView.getPoint(edgeView.getPointCount() - 1);
        if (point != null && rectangle != null) {
            int n2 = rectangle.x;
            int n3 = 1;
            if (point2.x > point3.x) {
                n2 += rectangle.width;
                n3 = -1;
            }
            int n4 = rectangle.y;
            int n5 = 1;
            if (point2.y > point3.y) {
                n4 += rectangle.height;
                n5 = -1;
            }
            int n6 = n2 + n3 * (rectangle.width * point.x / n);
            int n7 = n4 + n5 * (rectangle.height * point.y / n);
            return new Point(n6, n7);
        }
        return null;
    }

    public Dimension getLabelSize(EdgeView edgeView) {
        this.setView(edgeView);
        String string = edgeView.getGraph().convertValueToString(edgeView);
        if (string != null && string.toString().length() > 0) {
            this.fontGraphics.setFont(GraphConstants.getFont(edgeView.getAllAttributes()));
            this.metrics = this.fontGraphics.getFontMetrics();
            int n = this.metrics.stringWidth(string.toString());
            int n2 = this.metrics.getHeight();
            return new Dimension(n, n2);
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAllAttributes();
        this.beginDeco = GraphConstants.getLineBegin(map);
        this.beginSize = GraphConstants.getBeginSize(map);
        this.beginFill = GraphConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(map);
        this.endSize = GraphConstants.getEndSize(map);
        this.endFill = GraphConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(map);
        this.lineStyle = GraphConstants.getLineStyle(map);
        this.lineDash = GraphConstants.getDashPattern(map);
        this.borderColor = GraphConstants.getBorderColor(map);
        Color color = GraphConstants.getLineColor(map);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setOpaque(GraphConstants.isOpaque(map));
        this.setFont(GraphConstants.getFont(map));
        Color color3 = GraphConstants.getForeground(map);
        this.fontColor = color3 != null ? color3 : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = this.fontGraphics.getFontMetrics();
    }

    protected boolean isFillable(int n) {
        return n != 4 && n != 7 && n != 8;
    }

    public Rectangle getPaintBounds(EdgeView edgeView) {
        this.setView(edgeView);
        return edgeView.getShape().getBounds();
    }

    public void paint(Graphics graphics) {
        Shape shape = this.view.getShape();
        if (shape != null) {
            String string;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = 0;
            int n2 = 0;
            graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2));
            this.translateGraphics(graphics);
            graphics.setColor(this.getForeground());
            if (this.view.beginShape != null) {
                if (this.beginFill) {
                    graphics2D.fill(this.view.beginShape);
                }
                graphics2D.draw(this.view.beginShape);
            }
            if (this.view.endShape != null) {
                if (this.endFill) {
                    graphics2D.fill(this.view.endShape);
                }
                graphics2D.draw(this.view.endShape);
            }
            if (this.lineDash != null) {
                graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2, 10.0f, this.lineDash, 0.0f));
            }
            if (this.view.lineShape != null) {
                graphics2D.draw(this.view.lineShape);
            }
            if (this.selected) {
                graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                graphics2D.setColor(this.graph.getHighlightColor());
                if (this.view.beginShape != null) {
                    graphics2D.draw(this.view.beginShape);
                }
                if (this.view.lineShape != null) {
                    graphics2D.draw(this.view.lineShape);
                }
                if (this.view.endShape != null) {
                    graphics2D.draw(this.view.endShape);
                }
            }
            if (this.graph.getEditingCell() != this.view.getCell() && (string = this.graph.convertValueToString(this.view)) != null) {
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics.setFont(this.getFont());
                this.paintLabel(graphics, string.toString());
            }
        }
    }

    protected void translateGraphics(Graphics graphics) {
        graphics.translate(-this.getX(), -this.getY());
    }

    protected void paintLabel(Graphics graphics, String string) {
        Point point = this.getLabelPosition(this.view);
        if (point != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            int n2 = this.metrics.getHeight();
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(point.x - n / 2 - 1, point.y - n2 / 2 - 1, n + 2, n2 + 2);
            }
            if (this.borderColor != null) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(point.x - n / 2 - 1, point.y - n2 / 2 - 1, n + 2, n2 + 2);
            }
            graphics.setColor(this.fontColor);
            graphics.drawString(string, point.x - n / 2, point.y + n2 / 4);
        }
    }

    protected Shape createShape() {
        int n = this.view.getPointCount();
        if (n > 1) {
            EdgeView edgeView = this.view;
            Point[] pointArray = new Point[n];
            int n2 = 0;
            while (n2 < n) {
                pointArray[n2] = new Point(edgeView.getPoint(n2));
                ++n2;
            }
            if (this.view != edgeView) {
                this.view = edgeView;
                this.installAttributes(this.view);
            }
            if (this.view.sharedPath == null) {
                this.view.sharedPath = new GeneralPath(1);
            } else {
                this.view.sharedPath.reset();
            }
            this.view.endShape = null;
            this.view.lineShape = null;
            this.view.beginShape = null;
            Point point = pointArray[0];
            Point point2 = pointArray[n - 1];
            Point point3 = pointArray[1];
            Point point4 = pointArray[n - 2];
            if (this.beginDeco != 0) {
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, point3, point);
            }
            if (this.endDeco != 0) {
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, point4, point2);
            }
            this.view.sharedPath.moveTo(point.x, point.y);
            if (this.lineStyle == 12 && n > 2) {
                this.view.sharedPath.quadTo(point3.x, point3.y, point2.x, point2.y);
            } else if (this.lineStyle == 13 && n > 3) {
                this.view.sharedPath.curveTo(point3.x, point3.y, point4.x, point4.y, point2.x, point2.y);
            } else {
                int n3 = 1;
                while (n3 < n - 1) {
                    this.view.sharedPath.lineTo(pointArray[n3].x, pointArray[n3].y);
                    ++n3;
                }
                this.view.sharedPath.lineTo(point2.x, point2.y);
            }
            this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
            if (this.view.endShape != null) {
                this.view.sharedPath.append(this.view.endShape, true);
            }
            if (this.view.beginShape != null) {
                this.view.sharedPath.append(this.view.beginShape, true);
            }
            return this.view.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int n, int n2, Point point, Point point2) {
        int n3 = (int)Math.max(1.0, point2.distance(point));
        int n4 = -(n * (point2.x - point.x) / n3);
        int n5 = -(n * (point2.y - point.y) / n3);
        if (n2 == 9) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point2.x + n4 / 2 + n5 / 3, point2.y + n5 / 2 - n4 / 3);
            Point point3 = new Point(point2);
            point2.setLocation(point2.x + n4, point2.y + n5);
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point3.x + n4 / 2 - n5 / 3, point3.y + n5 / 2 + n4 / 3);
            return polygon;
        }
        if (n2 == 2 || n2 == 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point2.x + n4 + n5 / 2, point2.y + n5 - n4 / 2);
            Point point4 = new Point(point2);
            if (n2 == 1) {
                point2.setLocation(point2.x + n4 * 2 / 3, point2.y + n5 * 2 / 3);
                polygon.addPoint(point2.x, point2.y);
            } else if (n2 == 9) {
                point2.setLocation(point2.x + 2 * n4, point2.y + 2 * n5);
                polygon.addPoint(point2.x, point2.y);
            } else {
                point2.setLocation(point2.x + n4, point2.y + n5);
            }
            polygon.addPoint(point4.x + n4 - n5 / 2, point4.y + n5 + n4 / 2);
            return polygon;
        }
        if (n2 == 4) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo(point2.x + n4 + n5 / 2, point2.y + n5 - n4 / 2);
            generalPath.lineTo(point2.x, point2.y);
            generalPath.lineTo(point2.x + n4 - n5 / 2, point2.y + n5 + n4 / 2);
            return generalPath;
        }
        if (n2 == 5) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(point2.x + n4 / 2 - n / 2, point2.y + n5 / 2 - n / 2, n, n);
            point2.setLocation(point2.x + n4, point2.y + n5);
            return float_;
        }
        if (n2 == 7 || n2 == 8) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo(point2.x + n4 / 2 + n5 / 2, point2.y + n5 / 2 - n4 / 2);
            generalPath.lineTo(point2.x + n4 / 2 - n5 / 2, point2.y + n5 / 2 + n4 / 2);
            if (n2 == 8) {
                generalPath.moveTo(point2.x + n4 / 3 + n5 / 2, point2.y + n5 / 3 - n4 / 2);
                generalPath.lineTo(point2.x + n4 / 3 - n5 / 2, point2.y + n5 / 3 + n4 / 2);
            }
            return generalPath;
        }
        return null;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

