/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.AbstractSolution;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides.HeldKarpIterative;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides.TSP;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.Q;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.christofides.UpperBound;
import edu.ucsb.cs.jicos.services.Environment;

public class TSPMSTSolution
extends AbstractSolution {
    private boolean hasRun = false;
    private int bound;
    private boolean tour = false;
    private HeldKarpIterative hki;
    private int[] included;
    private int[] includedT;
    private int[] excluded;
    private int[] excludedT;
    private int iterations;
    private double[] weight;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$HeldKarpChristofides$TSPMSTSolution;

    public TSPMSTSolution(int n) {
        this.included = new int[0];
        this.includedT = new int[0];
        this.excluded = new int[0];
        this.excludedT = new int[0];
        this.iterations = n;
    }

    public TSPMSTSolution(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double[] dArray) {
        this.included = nArray;
        this.includedT = nArray2;
        this.excluded = nArray3;
        this.excludedT = nArray4;
        this.iterations = n;
        this.weight = dArray;
    }

    public static void main(String[] stringArray) {
    }

    public int getCost() {
        return this.hki.getBound();
    }

    private int getLowerBound(Object object, int n) {
        TSP tSP = (TSP)object;
        if (this.weight == null) {
            this.weight = new double[tSP.distance.length];
        }
        this.hki = new HeldKarpIterative(tSP.distance, this.included, this.includedT, this.excluded, this.excludedT, this.iterations, this.weight, n);
        this.hki.compute();
        this.tour = this.hki.isTour();
        this.bound = this.hki.getBound();
        this.hasRun = true;
        return this.bound;
    }

    public int getUpperBound(Environment environment) {
        TSP tSP = (TSP)environment.getInput();
        UpperBound upperBound = new UpperBound(tSP.distance, this.hki.getArrayListRepresentation());
        int n = 0;
        int[] nArray = null;
        try {
            nArray = upperBound.getTour();
            int n2 = nArray[0];
            int n3 = 1;
            while (n3 < nArray.length) {
                n += tSP.distance[n2][nArray[n3]];
                n2 = nArray[n3];
                ++n3;
            }
            n += tSP.distance[n2][nArray[0]];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Christofides went out of bounds");
            System.out.println(this.hki.debugDump());
            n = Integer.MAX_VALUE;
            System.exit(0);
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TSP SOLUTION OUTPUT\n");
        stringBuffer.append("Size: " + this.hki.degree.length);
        stringBuffer.append(", cost: " + this.hki.getBound());
        stringBuffer.append("\nTOUR: " + this.hki.getTour());
        return new String(stringBuffer);
    }

    public Q getChildren(Environment environment) {
        Q q = new Q();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (!$assertionsDisabled && this.hki == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.hki.degree == null) {
            throw new AssertionError();
        }
        int n4 = 1;
        while (n4 < this.hki.degree.length) {
            if (this.hki.degree[n4] > 2) {
                n = this.hki.getMaxAttachedFree(n4);
                if (n != -1) {
                    if (this.timesIncluded(n4) != 2 && this.timesIncluded(n) != 2) {
                        if (this.timesExcluded(n4) != this.hki.degree.length - 2 && this.timesExcluded(n) != this.hki.degree.length - 2) {
                            break;
                        }
                    } else {
                        n2 = n4;
                        n3 = n;
                    }
                }
            } else if (this.hki.degree[n4] < 2 && this.timesIncluded(n4) == 0 && this.timesIncluded(n = this.hki.getMaxAttachedFree(n4)) != 2) break;
            ++n4;
        }
        if (n4 == this.hki.degree.length) {
            n4 = n2;
            n = n3;
            if (n4 == -1) {
                System.out.println("No Edge Found with degree != 2");
                System.out.println("Tour: " + this.tour);
                if (!this.tour) {
                    this.hki.whyNotTour();
                }
                return q;
            }
        }
        int[] nArray = new int[this.included.length + 2];
        System.arraycopy(this.included, 0, nArray, 0, this.included.length);
        nArray[this.included.length] = n4;
        nArray[this.included.length + 1] = n;
        int[] nArray2 = new int[this.includedT.length + 2];
        System.arraycopy(this.includedT, 0, nArray2, 0, this.includedT.length);
        nArray2[this.includedT.length] = n;
        nArray2[this.includedT.length + 1] = n4;
        int[] nArray3 = new int[this.excluded.length + 2];
        System.arraycopy(this.excluded, 0, nArray3, 0, this.excluded.length);
        nArray3[this.excluded.length] = n4;
        nArray3[this.excluded.length + 1] = n;
        int[] nArray4 = new int[this.excludedT.length + 2];
        System.arraycopy(this.excludedT, 0, nArray4, 0, this.excludedT.length);
        nArray4[this.excludedT.length] = n;
        nArray4[this.excludedT.length + 1] = n4;
        q.add(new TSPMSTSolution(this.included, this.includedT, nArray3, nArray4, this.iterations, this.weight));
        if (this.timesIncluded(n4) != 2 && this.timesIncluded(n) != 2) {
            q.add(new TSPMSTSolution(nArray, nArray2, this.excluded, this.excludedT, this.iterations, this.weight));
        }
        return q;
    }

    public int getLowerBound(Environment environment) {
        if (!this.hasRun) {
            return this.getLowerBound(environment.getInput(), (Integer)environment.getShared().get());
        }
        return this.bound;
    }

    public boolean isComplete(Environment environment) {
        return this.tour;
    }

    private int timesIncluded(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.included.length) {
            if (this.included[n3] == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private int timesExcluded(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.excluded.length) {
            if (this.excluded[n3] == n) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$HeldKarpChristofides$TSPMSTSolution == null ? (class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$HeldKarpChristofides$TSPMSTSolution = TSPMSTSolution.class$("edu.ucsb.cs.jicos.applications.branchandbound.tsp.HeldKarpChristofides.TSPMSTSolution")) : class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$HeldKarpChristofides$TSPMSTSolution).desiredAssertionStatus();
    }
}

