/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Logarithmic
extends AbstractContinousDistribution {
    protected double my_p;
    private double t;
    private double h;
    private double a_prev = -1.0;
    protected static Logarithmic shared = new Logarithmic(0.5, AbstractDistribution.makeDefaultGenerator());

    public Logarithmic(double p, RandomElement randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(p);
    }

    public double nextDouble() {
        return this.nextDouble(this.my_p);
    }

    public double nextDouble(double a) {
        if (a != this.a_prev) {
            this.a_prev = a;
            if (a < 0.97) {
                this.t = -a / Math.log(1.0 - a);
            } else {
                this.h = Math.log(1.0 - a);
            }
        }
        double u = this.randomGenerator.raw();
        if (a < 0.97) {
            int k = 1;
            double p = this.t;
            while (u > p) {
                u -= p;
                p *= a * ((double)(++k) - 1.0) / (double)k;
            }
            return k;
        }
        if (u > a) {
            return 1.0;
        }
        double v = u = this.randomGenerator.raw();
        double q = 1.0 - Math.exp(v * this.h);
        if (u <= q * q) {
            int k = (int)(1.0 + Math.log(u) / Math.log(q));
            return k;
        }
        if (u > q) {
            return 1.0;
        }
        return 2.0;
    }

    public void setState(double p) {
        this.my_p = p;
    }

    public static double staticNextDouble(double p) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            return shared.nextDouble(p);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.my_p + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomGenerator) {
        Logarithmic logarithmic = shared;
        synchronized (logarithmic) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

