/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.searchspace.BooleanFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ValueVariableView
extends AbstractView
implements Configurable,
FreakSwingModel {
    private transient JPanel panel;
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private static Color DEFAULT_COLOR = Color.red;
    private IndividualList individuals;
    private boolean colorByFitness;
    private boolean displayOptimum = this.supportsDisplayOptimum();
    private int maximalNumberOfIndividuals = 1000;

    public ValueVariableView(Schedule schedule) {
        super(schedule);
        this.colorByFitness = this.supportsUseColor();
    }

    public void initialize() {
        super.initialize();
        this.displayOptimum &= this.supportsDisplayOptimum();
        this.colorByFitness &= this.supportsUseColor();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Unsupported searchspace.");
        }
    }

    public JPanel createPanel() {
        this.panel = new ValuePanel(this);
        return this.panel;
    }

    private boolean supportsUseColor() {
        if (!(this.getSchedule().getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            return false;
        }
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        try {
            fitness.getLowerBound();
            fitness.getUpperBound();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private boolean supportsDisplayOptimum() {
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        try {
            fitness.getGenotypeOptimum();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        super.update(data);
        ValueVariableView valueVariableView = this;
        synchronized (valueVariableView) {
            this.individuals = (IndividualList)data;
        }
        UpdateManager.markDirty(this);
    }

    public void flush() {
        if (this.panel == null) {
            return;
        }
        this.panel.repaint();
    }

    public String getName() {
        return "Value View";
    }

    public String getDescription() {
        return "";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public Color getColorByFitness(Individual individual) {
        if (!this.colorByFitness) {
            return DEFAULT_COLOR;
        }
        try {
            SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double lowerFitnessBound = fitness.getLowerBound();
            double upperFitnessBound = fitness.getUpperBound();
            double fitnessValue = fitness.evaluate(individual, this.individuals);
            double normalizedFitnessValue = (fitnessValue - lowerFitnessBound) / (upperFitnessBound - lowerFitnessBound);
            Color result = new Color(Color.HSBtoRGB((float)(1.0 - normalizedFitnessValue) * 0.8f, SATURATION, BRIGHTNESS));
            return result;
        }
        catch (UnsupportedOperationException ex) {
            return DEFAULT_COLOR;
        }
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    public void setPropertyColorByFitness(Boolean colorByFitness) {
        this.colorByFitness = colorByFitness != false && this.supportsUseColor();
    }

    public Boolean getPropertyColorByFitness() {
        return new Boolean(this.colorByFitness);
    }

    public String getShortDescriptionForColorByFitness() {
        return "Color individuals by fitness";
    }

    public String getLongDescriptionForColorByFitness() {
        return "Colors the displayed individuals by their fitness on a scale from violet (least fitness) to red (highest fitness). This feature can only be enabled if the fitness function knows the optimal fitness value.";
    }

    public void setPropertyDisplayOptimum(Boolean displayOptimum) {
        this.displayOptimum = displayOptimum != false && this.supportsDisplayOptimum();
    }

    public Boolean getPropertyDisplayOptimum() {
        return new Boolean(this.displayOptimum);
    }

    public String getShortDescriptionForDisplayOptimum() {
        return "Display global optimum";
    }

    public String getLongDescriptionForDisplayOptimum() {
        return "Displays the global optimum in the ValueView. This option can only be enabled if a global optimum exists and if the fitness function knows the optimum.";
    }

    public void setPropertyMaximalNumberOfIndividuals(Integer number) {
        if (number > 0) {
            this.maximalNumberOfIndividuals = number;
        }
    }

    public Integer getPropertyMaximalNumberOfIndividuals() {
        return new Integer(this.maximalNumberOfIndividuals);
    }

    public String getShortDescriptionForMaximalNumberOfIndividuals() {
        return "Maximal number of individuals";
    }

    public String getLongDescriptionForMaximalNumberOfIndividuals() {
        return "Sets the maximal number of individuals displayed in the ValueView. If more individuals are to be displayed, only the first ones are shown.";
    }

    class ValuePanel
    extends JPanel {
        public static final double X_SCALE = 0.8;
        public static final int MAX_POINT_SIZE = 8;
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private ValueVariableView ValueView;

        public ValuePanel(ValueVariableView ValueView) {
            this.ValueView = ValueView;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            g.setColor(Color.black);
            this.drawSearchSpace();
            ValueVariableView valueVariableView = this.ValueView;
            synchronized (valueVariableView) {
                IndividualList individuals = this.ValueView.getIndividualList();
                if (individuals != null) {
                    int i = 0;
                    while (i < individuals.size()) {
                        Individual individual = individuals.getIndividual(i);
                        g.setColor(this.ValueView.getColorByFitness(individual));
                        ++i;
                    }
                }
                if (this.ValueView.displayOptimum) {
                    try {
                        Genotype optimum = this.ValueView.getSchedule().getFitnessFunction().getGenotypeOptimum();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        private void drawSearchSpace() {
            this.graphics.setColor(Color.black);
            int y = 0;
            while (y <= this.currentHeight) {
                this.drawPixel(this.insets.left + 10, y + this.insets.top);
                ++y;
            }
            int x = 0;
            while (x <= this.currentWidth) {
                this.drawPixel(x + this.insets.left + 10, this.currentHeight + this.insets.top);
                ++x;
            }
            int j = 1;
            int i = this.insets.left + 15;
            while (i <= this.currentWidth) {
                if (j <= 35) {
                    String s = Integer.toString(j);
                    String x2 = "x";
                    String w = String.valueOf(x2) + s;
                    this.graphics.drawString(w, i, this.currentHeight + this.insets.top + 10);
                    this.graphics.drawLine(i, this.currentHeight + this.insets.top, i, this.currentHeight + this.insets.top - 5);
                }
                ++j;
                i += this.currentWidth / 35;
            }
            int l = 6;
            float i2 = 2.0f;
            while (i2 <= 13.0f) {
                this.graphics.drawLine(this.insets.left + 5, (int)((double)this.insets.top + (double)this.currentHeight * ((12.5 - (double)i2) / 12.0)), this.insets.left + 15, (int)((double)this.insets.top + (double)this.currentHeight * ((12.5 - (double)i2) / 12.0)));
                String gleich = "= ";
                String zahl = Integer.toString((int)((float)l));
                String w = String.valueOf(gleich) + zahl;
                this.graphics.drawString(w, this.insets.left - 10, (int)((double)this.insets.top + (double)this.currentHeight * ((12.5 - (double)i2) / 12.0)));
                this.graphics.drawLine(this.insets.left + 5, (int)((double)this.insets.top + (double)this.currentHeight * ((12.0 - (double)i2 + 1.5) / 12.0)), this.insets.left + 15, (int)((double)this.insets.top + (double)this.currentHeight * ((12.0 - (double)i2 + 1.5) / 12.0)));
                String ungleich = "!= ";
                zahl = Integer.toString((int)((float)l));
                w = String.valueOf(ungleich) + zahl;
                this.graphics.drawString(w, this.insets.left - 10, (int)((double)this.insets.top + (double)this.currentHeight * ((12.0 - (double)i2 + 1.5) / 12.0)));
                --l;
                i2 += 2.0f;
            }
            this.graphics.drawLine(this.currentWidth + this.insets.left + 5, this.currentHeight + this.insets.top - 5, this.currentWidth + this.insets.left + 10, this.currentHeight + this.insets.top);
            this.graphics.drawLine(this.currentWidth + this.insets.left + 5, this.currentHeight + this.insets.top + 5, this.currentWidth + this.insets.left + 10, this.currentHeight + this.insets.top);
            this.graphics.drawString("Variable", this.currentWidth - 30, this.currentHeight);
            this.graphics.drawLine(this.insets.left + 5, this.insets.top + 5, this.insets.left + 10, this.insets.top);
            this.graphics.drawLine(this.insets.left + 15, this.insets.top + 5, this.insets.left + 10, this.insets.top);
            this.graphics.drawString("Belegung", this.insets.left + 20, this.insets.top + 10);
        }

        private int getXDeviation(int y) {
            return (int)(Math.sin(Math.PI * ((double)y / (double)this.currentHeight)) * this.getXScale());
        }

        private double getXScale() {
            return (double)this.currentWidth * 0.4;
        }

        private void drawIndividual(int maxFitness, int fitness, int size) {
            int radius = this.getPointSize();
            Point point = new Point((int)((float)fitness / (float)maxFitness * (float)this.currentWidth), (int)((float)(this.currentHeight + this.insets.top - size * 20)));
            this.graphics.fillOval((int)point.getX() - (radius + 1) / 2 + 1, (int)point.getY() - (radius + 1) / 2, radius, radius);
        }

        private void drawPixel(int x, int y) {
            this.graphics.drawLine(x - 1, y, x + 1, y);
        }

        private int getPointSize() {
            return Math.max(1, Math.min(8, this.currentHeight / 50));
        }
    }
}

